<?php
namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class UserRolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create Permissions
        Permission::create(['name' => 'view-role']);
        Permission::create(['name' => 'create-role']);
        Permission::create(['name' => 'update-role']);
        Permission::create(['name' => 'delete-role']);

        Permission::create(['name' => 'view-permission']);
        Permission::create(['name' => 'create-permission']);
        Permission::create(['name' => 'update-permission']);
        Permission::create(['name' => 'delete-permission']);

        Permission::create(['name' => 'view-admin']);
        Permission::create(['name' => 'create-admin']);
        Permission::create(['name' => 'update-admin']);
        Permission::create(['name' => 'delete-admin']);

        Permission::create(['name' => 'view-user']);
        Permission::create(['name' => 'create-user']);
        Permission::create(['name' => 'update-user']);
        Permission::create(['name' => 'delete-user']);

        Permission::create(['name' => 'view-tutor']);
        Permission::create(['name' => 'create-tutor']);
        Permission::create(['name' => 'update-tutor']);
        Permission::create(['name' => 'delete-tutor']);

        Permission::create(['name' => 'view-student']);
        Permission::create(['name' => 'create-student']);
        Permission::create(['name' => 'update-student']);
        Permission::create(['name' => 'delete-student']);

        Permission::create(['name' => 'view-batch']);
        Permission::create(['name' => 'create-batch']);
        Permission::create(['name' => 'update-batch']);
        Permission::create(['name' => 'delete-batch']);

        Permission::create(['name' => 'view-lesson']);
        Permission::create(['name' => 'create-lesson']);
        Permission::create(['name' => 'update-lesson']);
        Permission::create(['name' => 'delete-lesson']);

        // Create Roles
        $superAdminRole = Role::create(['name' => 'super-admin']); //as super-admin
        $adminRole = Role::create(['name' => 'admin']);
        $tutorRole = Role::create(['name' => 'tutor']);

        // Lets give all permission to super-admin role.
        $allPermissionNames = Permission::pluck('name')->toArray();

        $superAdminRole->givePermissionTo($allPermissionNames);

        // Let's give few permissions to admin role.
        $adminRole->givePermissionTo(['create-role', 'view-role', 'update-role']);
        $adminRole->givePermissionTo(['create-permission', 'view-permission']);
        $adminRole->givePermissionTo(['create-user', 'view-user', 'update-user']);
        $adminRole->givePermissionTo(['create-tutor', 'view-tutor', 'update-tutor']);
        $adminRole->givePermissionTo(['create-student', 'view-student', 'update-student']);
        $adminRole->givePermissionTo(['create-batch', 'view-batch', 'update-batch']);
        $adminRole->givePermissionTo(['create-lesson', 'view-lesson', 'update-lesson']);

        // Let's give few permissions to tutor role.
        $tutorRole->givePermissionTo(['create-student', 'view-student', 'update-student']);
        $tutorRole->givePermissionTo(['create-batch', 'view-batch', 'update-batch']);
        $tutorRole->givePermissionTo(['create-lesson', 'view-lesson', 'update-lesson']);


        // Let's Create User and assign Role to it.

        $superAdminUser = User::firstOrCreate([
                    'email' => 'superadmin@readernest.com',
                ], [
                    'name' => 'Super Admin',
                    'email' => 'super@admin.com',
                    'password' => Hash::make ('P@ssw0rd'),
                ]);

        $superAdminUser->assignRole($superAdminRole);


        $adminUser = User::firstOrCreate([
                            'email' => 'admin@readernest.com'
                        ], [
                            'name' => 'Admin',
                            'email' => 'admin@readernest.com',
                            'password' => Hash::make ('P@ssw0rd'),
                        ]);

        $adminUser->assignRole($adminRole);


        $tutorUser = User::firstOrCreate([
                            'email' => 'tutor@readernest.com',
                        ], [
                            'name' => 'Tutor',
                            'email' => 'tutor@readernest.com',
                            'password' => Hash::make('P@ssw0rd'),
                        ]);

        $tutorUser->assignRole($tutorRole);
    }
}