
@extends('layouts.master')
@if (isset($page_title) && $page_title != '')
    @section('title', $page_title . ' - ' . config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    
  <div class="row">
    <div class="col-md-12 mb-4">
        <div class="card card-action mb-6">
            <div class="card-header align-items-center">
              <h5 class="card-action-title mb-0">
                <i class="ti ti-chart-bar ti-lg text-body me-4"></i>Activity Timeline
              </h5>
            </div>
            <div class="card-body pt-3">
              <ul class="timeline mb-0">
                @foreach ($activities as $key => $activity)
                <li class="timeline-item timeline-item-transparent">
                  <span class="timeline-point timeline-point-primary"></span>
                  <div class="timeline-event">
                    @php 
                        $activity = get_activity_details($activity);
                    @endphp
                    <div class="timeline-header mb-3">
                      <h6 class="mb-0">{{ $activity['subject'] }} is {{ $activity['description'] }}</h6>
                      <small class="text-muted">{{ date(config('constant.date_format'), strtotime($activity['created_at'])) }}</small>
                    </div>
                    <p class="mb-2">
                        <a href="{{$activity['causer_url']}}">{{ $activity['causer'] }}</a> {{ $activity['description_lg'] }} <a href="{{$activity['subject_url']}}">{{ $activity['subject'] }}</a>
                    </p>
                  </div>
                </li>
                @endforeach
              </ul>
            </div>
        </div>
    </div>
  </div>
</div>
@endsection
@push('after-scripts')
@endpush
@section('page-script')
  @if (Session::has('alert-message'))
      <script>
          Toast.fire({
              type: "{{ Session::get('alert-class', 'info') }}",
              title: "{{ Session::get('alert-message') }}"
          });
      </script>
  @endif
@endsection