@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('content')
<div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0">Add Batch</h5>
    </div>
    <div class="card-body pt-4">
        <form action="{{ route('batches.store') }}"  class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST">
            @csrf
            <div class="col-12 fv-plugins-icon-container">
                <div class="form-group @error('name') is-invalid @enderror">
                    <label class="control-label">Name <span style="color: red">*</span></label>
                    <input type="text" class="form-control" name="name" id="name" value="{{ old('name') }}" placeholder="Name Here" maxlength="150">
                    @error('first_name')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-12 fv-plugins-icon-container">
                <div class="form-group @error('description') is-invalid @enderror">
                    <label class="control-label">Description</label>
                    <textarea class="form-control" name="description" id="description" placeholder="Description Here" maxlength="150">{{ old( 'description') }}</textarea>
                    @error('description')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-4 fv-plugins-icon-container">
              <div class="form-group @error('tutor_id') is-invalid @enderror">
                  <label class="control-label">Tutor</label>
                  <select id="tutor_id" name="tutor_id" class="form-select">
                      <option disabled>Select Tutor</option>
                      @foreach ($tutors as $tutor)
                        <option value="{{ $tutor->id }}">{{ $tutor->first_name.' '.$tutor->last_name }} </option>
                      @endforeach
                  </select>
                  @error('tutor_id')
                      <span class="invalid-feedback" role="alert">
                          {{ $message }}
                      </span>
                  @enderror
              </div>
            </div>
            <div class="col-4 fv-plugins-icon-container">
                <div class="form-group @error('start_date') is-invalid @enderror">
                    <label class="control-label">Start Date <span style="color: red">*</span></label>
                    <input type="datetime-local" class="form-control" name="start_date" id="start_date" value="{{ old('start_date') }}" />
                    @error('start_date')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-4 fv-plugins-icon-container">
                <div class="form-group @error('lesson_numbers') is-invalid @enderror">
                    <label class="control-label">Number of Lessons <span style="color: red">*</span></label>
                    <input type="number" class="form-control" name="lesson_numbers" id="lesson_numbers" value="{{ old('lesson_numbers') }}" />
                    @error('lesson_numbers')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-4 fv-plugins-icon-container">
                <div class="form-group @error('charge') is-invalid @enderror">
                    <label class="control-label">Charges / Lesson  <span style="color: red">*</span></label>
                    <input type="number" class="form-control" name="charge" id="charge" value="{{ old('charge') }}" placeholder="Per Lesson Charge" maxlength="150">
                    @error('charge')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="mb-4 col-md-4 form-password-toggle fv-plugins-icon-container  @error('duration') is-invalid @enderror">
                <label class="form-label" for="status">Lesson Duration <span style="color: red">*</span></label>
                <select id="duration" name="duration" class="form-select">
                    <option disabled></option>
                    @foreach ($timings as $timing)
                    <option value="{{$timing}}">{{$timing}} min</option>
                    @endforeach
                </select>
                @error('duration')
                    <div class="fv-plugins-message-container fv-plugins-message-container--enabled invalid-feedback">
                        {{ $message }}
                    </div>
                @enderror              
            </div>
            <div class="mb-4 col-md-4 form-password-toggle fv-plugins-icon-container  @error('is_report_required') is-invalid @enderror">
                <label class="form-label" for="status">Lesson Report Required <span style="color: red">*</span></label>
                <select id="is_report_required" name="is_report_required" class="form-select">
                    <option disabled></option>
                    <option value="0">NO</option>
                    <option value="1">YES</option>
                </select>
                @error('is_report_required')
                    <div class="fv-plugins-message-container fv-plugins-message-container--enabled invalid-feedback">
                        {{ $message }}
                    </div>
                @enderror              
            </div>
            <div class="col-12 form-password-toggle fv-plugins-icon-container  @error('batch_type') is-invalid @enderror">
                <label class="form-label" for="status">Batch Type <span style="color: red">*</span></label>
                <select id="batch_type" name="batch_type" class="form-select">
                    <option disabled></option>
                    <option value="1">GROUP</option>
                    <option value="0">INDIVIDUAL</option>
                </select>
                @error('batch_type')
                    <div class="fv-plugins-message-container fv-plugins-message-container--enabled invalid-feedback">
                        {{ $message }}
                    </div>
                @enderror              
            </div>
            <div class="col-6 fv-plugins-icon-container">
              <div class="accordion stick-top accordion-custom-button course-content-fixed" id="courseContent">
                  <div class="accordion-item mb-0 active">
                    <div class="accordion-header" id="headingOne">
                      <button type="button" class="accordion-button" data-bs-toggle="collapse" data-bs-target="#chapterOne" aria-expanded="true" aria-controls="chapterOne">
                        <span class="d-flex flex-column">
                          <span class="h5 mb-0">Students</span>
                        </span>
                      </button>
                    </div>
                    <div id="chapterOne" class="accordion-collapse collapse show" data-bs-parent="#courseContent" style="">
                      <div class="accordion-body py-4">
                      <input class="form-control" maxlength="100" onkeyup="tableSearch();" placeholder="Search" id="search-students" type="text"><br/>
                        @foreach ($students as $student)
                          <div class="form-check d-flex align-items-center gap-1 mb-4 student-row" data-name="{{ $student->first_name.' '.$student->last_name }}">
                            <input class="form-check-input" name="students[]" value="{{ $student->id }}" type="checkbox" id="student_{{ $student->id }}">
                            <label for="defaultCheck1" class="form-check-label ms-4">
                              <span class="mb-0 h6">{{ $student->first_name.' '.$student->last_name }}</span>
                            </label>
                          </div>
                        @endforeach
                      </div>
                    </div>
                  </div>
                </div>
            </div>
            <div class="col-6 fv-plugins-icon-container">
              <div class="accordion stick-top accordion-custom-button course-content-fixed" id="daysContent">
                  <div class="accordion-item mb-0 active">
                    <div class="accordion-header" id="headingOne">
                      <button type="button" class="accordion-button" data-bs-toggle="collapse" data-bs-target="#days" aria-expanded="true" aria-controls="chapterOne">
                        <span class="d-flex flex-column">
                          <span class="h5 mb-0">Lesson Days</span>
                        </span>
                      </button>
                    </div>
                    <div id="days" class="accordion-collapse collapse show" data-bs-parent="#daysContent" style="">
                      <div class="accordion-body py-4">
                        @foreach ($days as $day)
                          <div class="form-check d-flex align-items-center gap-1 mb-4">
                            <input class="form-check-input" name="days[]" value="{{ $day['id'] }}" type="checkbox" id="days_{{ $day['id'] }}">
                            <label for="defaultCheck1" class="form-check-label ms-4">
                              <span class="mb-0 h6">{{ $day['name'] }}</span>
                            </label>
                          </div>
                        @endforeach
                      </div>
                    </div>
                  </div>
                </div>
            </div>
            <div class="col-12 text-center">
                <button type="submit" class="btn btn-primary me-3 waves-effect waves-light">Submit</button>
                <a href="{{ route('batches')}}" class="btn btn-label-secondary waves-effect">Cancel</a>
            </div>
        </form>
    </div>
</div>
<br/>
<style>
  .accordion-body {
    height: 200px;
    overflow-x: hidden;
    overflow-y: auto;
  }
</style>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    $(document).ready(function() {
    });

    function tableSearch(){
      var input, filter;
      filter = $('#search-students').val().toLowerCase();


      if(filter == ""){
        $('.student-row').each(function(evt, element){
          if($(element).hasClass('d-none')) {
            $(element).removeClass('d-none');
          }
        });
        return;
      }

      $('.student-row').each(function(evt, element){
          element = $(element), name = element.data('name');

        if (name.toLowerCase().includes(filter)) {
          $(element).removeClass('d-none');
        } else {
          $(element).addClass('d-none');
        }
      });
    }

</script>
@endsection