@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('content')
<div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0">{{$header}}</h5>
    </div>
    <div class="card-body pt-4">
        <form action="{{ route('batches.lesson.store') }}"  class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST" novalidate="novalidate">
            @csrf
            <input type="hidden" name="id" id="id" value="{{ isset($batch->id) ? $batch->id : '' }}">
            <div class="col-12 fv-plugins-icon-container">
              <div class="form-group @error('name') is-invalid @enderror">
                  <label class="control-label">Name <span style="color: red">*</span></label>
                  <input type="text" class="form-control" name="name" id="name" value="{{ old('name') }}" placeholder="Name Here" maxlength="150">
                  @error('first_name')
                      <span class="invalid-feedback" role="alert">
                          {{ $message }}
                      </span>
                  @enderror
              </div>
            </div>
            <div class="col-3 fv-plugins-icon-container">
                <div class="form-group @error('start_date') is-invalid @enderror">
                    <label class="control-label">Start Date <span style="color: red">*</span></label>
                    <input type="datetime-local" class="form-control" name="start_date" id="start_date" value="{{ old('start_date') }}" />
                    @error('start_date')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-3 fv-plugins-icon-container">
                <div class="form-group @error('end_date') is-invalid @enderror">
                    <label class="control-label">End Date <span style="color: red">*</span></label>
                    <input type="datetime-local" class="form-control" name="end_date" id="end_date" value="{{ old('end_date') }}" />
                    @error('end_date')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="mb-4 col-md-3 form-password-toggle fv-plugins-icon-container  @error('is_report_required') is-invalid @enderror">
                <label class="form-label" for="status">Lesson Report Required <span style="color: red">*</span></label>
                <select id="is_report_required" name="is_report_required" class="form-select">
                    <option disabled></option>
                    <option value="0">NO</option>
                    <option value="1">YES</option>
                </select>
                @error('is_report_required')
                    <div class="fv-plugins-message-container fv-plugins-message-container--enabled invalid-feedback">
                        {{ $message }}
                    </div>
                @enderror              
            </div>
            <div class="col-3 fv-plugins-icon-container">
                <div class="form-group @error('charge') is-invalid @enderror">
                    <label class="control-label">Charges / Lesson  <span style="color: red">*</span></label>
                    <input type="number" class="form-control" name="charge" id="charge" value="{{ old('charge') }}" placeholder="Per Lesson Charge" maxlength="150">
                    @error('charge')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-12 text-center">
                <button type="submit" class="btn btn-primary me-3 waves-effect waves-light">Submit</button>
                <a href="{{ route('batches')}}" class="btn btn-label-secondary waves-effect">Cancel</a>
            </div>
        </form>
    </div>
</div>
<br/>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    $(document).ready(function() {
    });
</script>
@endsection