@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('content')
<div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0">{{$header}}</h5>
    </div>
    <div class="card-body pt-4">
        <form action="{{ route('batches.student.store') }}"  class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST" novalidate="novalidate">
            @csrf
            <input type="hidden" name="id" id="id" value="{{ isset($batch->id) ? $batch->id : '' }}">
            
            <div class="col-6 fv-plugins-icon-container">
            <div class="accordion stick-top accordion-custom-button course-content-fixed" id="courseContent">
                <div class="accordion-item mb-0 active">
                    <div class="accordion-header" id="headingOne">
                    <button type="button" class="accordion-button" data-bs-toggle="collapse" data-bs-target="#chapterOne" aria-expanded="true" aria-controls="chapterOne">
                        <span class="d-flex flex-column">
                        <span class="h5 mb-0">Students</span>
                        </span>
                    </button>
                    </div>
                    <div id="chapterOne" class="accordion-collapse collapse show" data-bs-parent="#courseContent" style="">
                    <div class="accordion-body py-4">
                        @foreach ($students as $student)
                        <div class="form-check d-flex align-items-center gap-1 mb-4">
                            <input class="form-check-input" name="students[]" value="{{ $student->id }}" type="checkbox" id="student_{{ $student->id }}">
                            <label for="defaultCheck1" class="form-check-label ms-4">
                            <span class="mb-0 h6">{{ $student->first_name.' '.$student->last_name }}</span>
                            </label>
                        </div>
                        @endforeach
                    </div>
                    </div>
                </div>
                </div>
            </div>
            <div class="col-12 text-center">
                <button type="submit" class="btn btn-primary me-3 waves-effect waves-light">Submit</button>
                <a href="{{ route('batches')}}" class="btn btn-label-secondary waves-effect">Cancel</a>
            </div>
        </form>
    </div>
</div>
<br/>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    $(document).ready(function() {
    });
</script>
@endsection