@extends('layouts.master')

@section('content')
<div class="container">
    <h2>Send Bulk Email</h2>
    <form action="{{ route('bulk.mail.send') }}" method="POST">
        @csrf
        <div class="mb-3">
            <label for="recipient_type" class="form-label">Send To</label>
            <select class="form-control" id="recipient_type" name="recipient_type" required>
                <option value="student">Students</option>
                <option value="tutor">Tutors</option>
            </select>
        </div>
        <div class="mb-3" id="students-dropdown">
            <label for="students" class="form-label">Select Students</label>
            <select class="form-control" id="students" name="students[]" multiple>
                @foreach($students as $student)
                    <option value="{{ $student->user_id }}">{{ $student->full_name }}</option>
                @endforeach
            </select>
        </div>
        <div class="mb-3" id="tutors-dropdown" style="display:none;">
            <label for="tutors" class="form-label">Select Tutors</label>
            <select class="form-control" id="tutors" name="tutors[]" multiple>
                @foreach($tutors as $tutor)
                    <option value="{{ $tutor->user_id }}">{{ $tutor->full_name }}</option>
                @endforeach
            </select>
        </div>
        <div class="mb-3">
            <label for="subject" class="form-label">Subject</label>
            <input type="text" class="form-control" id="subject" name="subject" required>
        </div>
        <div class="mb-3">
            <label for="message" class="form-label">Message</label>
            <textarea class="form-control" id="message" name="message" rows="5" required></textarea>
        </div>
        <button type="submit" class="btn btn-primary">Send Email</button>
    </form>
</div>
@endsection

@section('page-script')
<!-- Select2 CSS & JS from CDN for multi-select -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('#students').select2({
            placeholder: 'Select students',
            width: '100%'
        });
        $('#tutors').select2({
            placeholder: 'Select tutors',
            width: '100%'
        });
        $('#recipient_type').on('change', function() {
            if ($(this).val() === 'student') {
                $('#students-dropdown').show();
                $('#tutors-dropdown').hide();
            } else {
                $('#students-dropdown').hide();
                $('#tutors-dropdown').show();
            }
        }).trigger('change');
    });
</script>
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
@endsection
