<aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme" data-bg-class="bg-menu-theme" style="touch-action: none; user-select: none;">
    <div class="app-brand demo">
        <a href="{{ route('home')}}" class="app-brand-link">
        <span class="app-brand-logo demo">
            <img src="{{ asset('assets/img/logo-small.png')}}" />
        </span>
        <span class="app-brand-text demo menu-text fw-bold">{{ config('app.name')}}</span>
        </a>
        <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
        <i class="ti menu-toggle-icon d-none d-xl-block align-middle"></i>
        <i class="ti ti-x d-block d-xl-none ti-md align-middle"></i>
        </a>
    </div>
    <div class="menu-inner-shadow" style="display: block;"></div>
    <ul class="menu-inner py-1 ps ps--active-y">
        @if(Auth::user()->role_name != RoleStudent)
            <!-- Dashboards -->
            <li class="menu-item">
            <a href="{{ route('home') }}" class="menu-link">
                    <i class="menu-icon tf-icons ti ti-chart-bar"></i>
                    <div data-i18n="Dashboard" >Dashboard</div>
                </a>
            </li>
        @endif

        @canany(['view-tutor','view-student','view-admin'])
        <li class="menu-item">
            <a href="javascript:void(0);" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons ti ti-users-group"></i>
                <div>People</div>
            </a>
            <ul class="menu-sub">
                @can('view-tutor')
                <li class="menu-item">
                    <a href="{{ route('tutors') }}" class="menu-link">
                        <div data-i18n="Tutors">Tutors</div>
                    </a>
                </li>
                @endcan
                @can('view-student')
                <li class="menu-item">
                    <a href="{{ route('students') }}" class="menu-link">
                        <div data-i18n="Students">Students</div>
                    </a>
                </li>
                @endcan
                @can('view-admin')
                <li class="menu-item">
                    <a href="{{ route('admins') }}" class="menu-link">
                        <div data-i18n="Admins">Admins</div>
                    </a>
                </li>
                @endcan
            </ul>
        </li>
        @endcan
        @canany(['view-batch'])
        <li class="menu-item">
            <a href="javascript:void(0);" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons ti ti-activity"></i>
                <div data-i18n="Activity">Activity</div>
            </a>
            <ul class="menu-sub">
                <li class="menu-item">
                    <a href="{{ route('batches') }}"  class="menu-link">
                        <div data-i18n="Batches">Batches</div>
                    </a>
                </li>
                @if(Auth::user()->role_name != RoleStudent)
                    <li class="menu-item">
                        <a href="{{ route('tutors.schedule') }}"  class="menu-link">
                            <div data-i18n="Calendar"></div>
                        </a>
                    </li>
                @endif
            </ul>
        </li>
        @endcan
        @canany(['view-payment-order'])
        <li class="menu-item">
            <a href="{{ route('payment-orders') }}" class="menu-link">
                <i class="menu-icon tf-icons ti ti-file-invoice"></i>
                <div data-i18n="Payment Orders"></div>
            </a>
        </li>
        @endcan
        @canany(['view-ticket'])
        <li class="menu-item">
            <a href="{{ route('tickets') }}" class="menu-link">
                <i class="menu-icon tf-icons ti ti-alarm"></i>
                <div data-i18n="Tickets"></div>
                <div class="badge bg-danger rounded-pill ms-auto">
                    {{ unread_ticket_count() }}
                </div>
            </a>
        </li>
        @endcan
        @if(Auth::user()->role_name != RoleStudent)
            <li class="menu-item">
                <a href="{{ route('lessons.reports') }}" class="menu-link">
                    <i class="menu-icon tf-icons ti ti-report"></i>
                    <div data-i18n="Reports"></div>
                </a>
            </li>
        @endif
        @canany(['view-role', 'view-permission'])
        <li class="menu-item">
            <a href="javascript:void(0);" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons ti ti-settings"></i>
                <div data-i18n="Settings">Settings</div>
            </a>
            <ul class="menu-sub">
                @can('view-user')
                <li class="menu-item">
                    <a href="{{ route('users') }}" class="menu-link">
                        <div data-i18n="Users">Users</div>
                    </a>
                </li>
                @endcan
                @can('view-role')
                <li class="menu-item">
                    <a href="{{ route('roles') }}" class="menu-link">
                        <div data-i18n="Roles">Roles</div>
                    </a>
                </li>
                @endcan
                @can('view-permission')
                <li class="menu-item">
                    <a href="{{ route('permissions') }}" class="menu-link">
                        <div data-i18n="Permissions">Permissions</div>
                    </a>
                </li>
                @endcan
            </ul>
        </li>
        @endcan
        @if(Auth::user()->role_name == 'super-admin')
            <li class="menu-item">
            <a href="{{ route('bulk.mail') }}" class="menu-link">
                <i class="menu-icon tf-icons ti ti-mail"></i>
                <div data-i18n="Bulk Mail">Bulk Mail</div>
            </a>
        </li>
        @endif
        @php
            //dd(Auth::user()->getRoleNames()->get(0));
            //dd(Auth::user()->load('roles.permissions'));
            //{{ Auth::user()->roles->pluck('name') }}
            //dd(Auth::user()->roles->get(0)->getPermissionNames())
        @endphp
        <div class="ps__rail-x" style="left: 0px; bottom: -899px;">
            <div class="ps__thumb-x" tabindex="0" style="left: 0px; width: 0px;"></div>
        </div>
        <div class="ps__rail-y" style="top: 899px; height: 147px; right: 4px;">
            <div class="ps__thumb-y" tabindex="0" style="top: 76px; height: 12px;"></div>
        </div>
    </ul>
</aside>
