@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('page-style')
<style type="text/css">
	.th-width{
		width: 25% !important;
	}
	h4.text-custom{
        font-weight: 500;
        color: #2cabe3;
    }
</style>
@endsection

@section('content')

@php
  $total_amount = 0;

  foreach ( $paymentOrder->lessons as $paymentOrderLesson)
  $total_amount += $paymentOrderLesson->lesson->charge;
@endphp
  <div class="card mb-4">
      <div class="card-header border-bottom">
        <h5 class="card-title mb-0">View Payment Order</h5>
      </div>
      <div class="card-body pt-4">
        <div class="row">
          <div class="col-xl-3 col-md-12 col-sm-5 col-12 mb-xl-0 mb-md-6 mb-sm-0 mb-6">
            <h6>Payment Order:</h6>
            <p class="mb-1">{{ old( 'number', isset($paymentOrder->number) ? $paymentOrder->number : '') }}</p>
            <p class="mb-1">
              {{ date(config('constant.date_format'), strtotime($paymentOrder->start_date)) }} to 
              {{ date(config('constant.date_format'), strtotime($paymentOrder->end_date)) }}
            </p>
          </div>
          <div class="col-xl-3 col-md-12 col-sm-7 col-12">
            <h6>Tutor:</h6>
            <p class="mb-1">{{ $paymentOrder->tutor->full_name }}</p>
            <p class="mb-1">{{ $paymentOrder->tutor->user->email }}</p>
          </div>
          <div class="col-xl-3 col-md-12 col-sm-7 col-12">
            <h6>Total Value:</h6>
            <h4>₹ {{ $total_amount }}</h4>
          </div>
          <div class="col-xl-3 col-md-12 col-sm-7 col-12">
            @if($paymentOrder->status == 0)
              <span class="btn btn-label-warning warning-effect" style="margin-bottom: 40px;">Raised</span>
              <form action="{{ route('payment-orders.paid') }}"  class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST">
                @csrf
                <input type="hidden" id="order_id" name="order_id" value="{{ $paymentOrder->id }}">
                
                <div class="row">
                  <div class="col-md-12">
                    <button type="submit" class="btn btn-primary me-3 waves-effect waves-light">Mark Paid</button>
                  </div>
                </div>
              </form>
            @else
              <span class="btn btn-label-success success-effect mb-5">Paid</span>
              <p class="mb-1">{{ date(config('constant.date_format_new'), strtotime($paymentOrder->paid_at)) }}</span>
            @endif
          </div>
        </div>
          <ul class="list-unstyled my-3 py-1">
              
          </ul>
      </div>
  </div>
  <div class="card">
    <div class="card-header">
      <h5 class="card-title mb-0">Lessons ({{$paymentOrder->lessons->count() }})</h5>
    </div>
    <div class="card-body">
      <div class="card-body table-responsive pt-4">
        <table id="DataTable1" class="datatables-roles table">
          <thead class="border-top">
            <tr>
              <th></th>
              <th>Name</th>
              <th>Batch</th>
              <th>Start Date</th>
              <th>End Date</th>
              <th>Charge</th>
            </tr>
          </thead>
          <tbody>
            @php
              $i = 1;
            @endphp
            @foreach ( $paymentOrder->lessons as $paymentOrderLesson)
              <tr>
                <td>{{ $i }}</td>
                <td>{{ $paymentOrderLesson->lesson->name }}</td>
                <td>{{ $paymentOrderLesson->lesson->batch->name }}</td>
                <td>{{ date(config('constant.date_format_new'), strtotime($paymentOrderLesson->lesson->start_date))  }}</td>
                <td>{{ date(config('constant.date_format_new'), strtotime($paymentOrderLesson->lesson->end_date))  }}</td>
                <td>{{ $paymentOrderLesson->lesson->charge }}</td>
              </tr>
              
            @php 
              $total_amount += $paymentOrderLesson->lesson->charge;
              $i++; 
            @endphp
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
@endsection
@section('page-script')

@endsection