@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('content')
<div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0">Add Permission</h5>
    </div>
    <div class="card-body pt-4">
        <form action="{{ route('permissions.store') }}"  class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST">
            @csrf
            <div class="col-12 fv-plugins-icon-container">
                <div class="form-group @error('name') is-invalid @enderror">
                    <label class="control-label">Name <span style="color: red">*</span></label>
                    <input type="text" class="form-control" name="name" id="name" value="{{ old('name') }}" placeholder="Name Here" maxlength="150">
                    @error('name')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-12 fv-plugins-icon-container">
                <div class="form-group @error('description') is-invalid @enderror">
                    <label class="control-label">Description <span style="color: red">*</span></label>
                    <textarea class="form-control" name="description" id="description" placeholder="Display Name Here" maxlength="150">{{ old( 'description') }}</textarea>
                    @error('description')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            @if(isset($permissions) && $permissions->count()>0)
                <div class="col-12 fv-plugins-icon-container">
                    <div class="form-group @error('description') is-invalid @enderror">
                        <label class="control-label">Permissions <span style="color: red">*</span></label>
                        <div class="table-responsive mt-4">
                            <table class="table">
                            <thead>
                                <tr>
                                <th class="text-nowrap">Name</th>
                                <th class="text-nowrap">Permission</th>
                                <th class="text-nowrap text-center"></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($permissions as $permission)
                                <tr>
                                <td class="text-nowrap text-heading">{{$permission->display_name}}</td>
                                <td class="text-nowrap text-heading">{{$permission->name}}</td>
                                <td>
                                    <div class="form-check d-flex justify-content-center">
                                        <input type="checkbox" name="permissions[]" id="{{$permission->name}}" value="{{$permission->name}}">
                                    </div>
                                </td>
                                </tr>
                                @endforeach
                            </tbody>
                            </table>
                        </div>        
                    </div>
                </div>
            @endif
            <div class="col-12 text-center">
                <button type="submit" class="btn btn-primary me-3 waves-effect waves-light">Submit</button>
                <a href="{{ route('permissions')}}" class="btn btn-label-secondary waves-effect">Cancel</a>
            </div>
        </form>
    </div>
</div>
<br/>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    var table;
    $(document).ready(function() {
      $('#chkHideCompletedLesson').change(function(){
        if($(this).is(":checked")) {
          $('.lesson.completed').hide();
        }
        else{
          $('.lesson').show();
        }
      });
    });
</script>
@endsection