@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('content')
<div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0">Edit Permission</h5>
    </div>
    <div class="card-body pt-4">
        <form action="{{ route('permissions.update', $permission->id) }}"  class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST" novalidate="novalidate">
            @csrf
            <input type="hidden" name="role_id" id="role_id" value="{{ isset($role->id) ? $role->id : '' }}">
            <div class="col-12 fv-plugins-icon-container">
                <div class="form-group @error('name') is-invalid @enderror">
                    <label class="control-label">Name <span style="color: red">*</span></label>
                    <input type="text" class="form-control" name="name" id="name" value="{{ old( 'name', isset($permission->name) ? $permission->name : '') }}" placeholder="Name Here" maxlength="150">
                    @error('name')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-12 text-center">
                <button type="submit" class="btn btn-primary me-3 waves-effect waves-light">Submit</button>
                <a href="{{ route('permissions')}}" class="btn btn-label-secondary waves-effect">Cancel</a>
            </div>
        </form>
    </div>
</div>
<br/>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    var table;
    $(document).ready(function() {
      $('#chkHideCompletedLesson').change(function(){
        if($(this).is(":checked")) {
          $('.lesson.completed').hide();
        }
        else{
          $('.lesson').show();
        }
      });
    });
</script>
@endsection