@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('content')
<link rel="stylesheet" href="{{ asset('assets/vendor/css/pages/page-profile.css')}}" />
<div class="row fv-plugins-icon-container">
    <div class="col-md-12">
        <div class="nav-align-top">
            <ul class="nav nav-pills flex-column flex-md-row mb-6 gap-2 gap-lg-0">
                <li class="nav-item">
                    <a class="nav-link active waves-effect waves-light" href="{{ route('profile') }}"><i class="ti-sm ti ti-users me-1_5"></i> Account</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link waves-effect waves-light" href="{{ route('profile.password') }}"><i class="ti-sm ti ti-lock me-1_5"></i> Security</a>
                </li>
            </ul>
        </div>
        <div class="card mb-6">
            <!-- Account -->
            <div class="card-body">
                <div class="d-flex align-items-start align-items-sm-center gap-6">
                    <img src="{{ asset('assets/img/avatars/user.png')}}" alt="user-avatar" class="d-block w-px-100 h-px-100 rounded" id="uploadedAvatar">
                </div>
            </div>
            <div class="card-body pt-4">
                <form action="{{ route('profile.submit') }}" name="profileform" id="profileform" method="POST" class="fv-plugins-bootstrap5 fv-plugins-framework" novalidate="novalidate">
                    @csrf
                    <div class="row">
                        <div class="mb-4 col-md-6">
                            <label for="role" class="form-label">Role</label><br/>
                            <span class="w-40 btn btn-label-info info-effect waves-effect">
                                {{ Auth::user()->roles->count() ? Auth::user()->roles->get(0)->display_name : ''}}
                            </span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="mb-4 col-md-6 fv-plugins-icon-container @error('name') is-invalid @enderror">
                            <label for="name" class="form-label">Name</label>
                            <input class="form-control" type="text" id="name" name="name" value="{{ old( 'name', isset(Auth::user()->name) ? Auth::user()->name : '') }}" autofocus="">
                            <div class="fv-plugins-message-container fv-plugins-message-container--enabled invalid-feedback"></div>
                        </div>
                        <div class="mb-4 col-md-6">
                            <label for="email" class="form-label">E-mail</label>
                            <input class="form-control" type="text" id="email" name="email" value="{{ old( 'email', isset(Auth::user()->email) ? Auth::user()->email : '') }}" placeholder="john.doe@example.com" readonly>
                        </div>
                    </div>
                    <div class="mt-2">
                        <button type="submit" class="btn btn-primary me-3 waves-effect waves-light">Save changes</button>
                        <a href="{{ route('home')}}" class="btn btn-label-secondary waves-effect">Cancel</a>
                    </div>
                    <input type="hidden">
                </form>
            </div>
            <!-- /Account -->
        </div>
    </div>
</div>
@endsection