@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('content')
<div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0">Edit Student</h5>
    </div>
    <div class="card-body pt-4">
        <form action="{{ route('students.store') }}"  class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST" novalidate="novalidate">
            @csrf
            <input type="hidden" name="id" id="id" value="{{ isset($student->id) ? $student->id : '' }}">
            <div class="col-6 fv-plugins-icon-container">
                <div class="form-group @error('first_name') is-invalid @enderror">
                    <label class="control-label">First Name <span style="color: red">*</span></label>
                    <input type="text" class="form-control" name="first_name" id="first_name" value="{{ old( 'first_name', isset($student->first_name) ? $student->first_name : '') }}" placeholder="First Name Here" maxlength="150">
                    @error('first_name')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-6 fv-plugins-icon-container">
                <div class="form-group @error('last_name') is-invalid @enderror">
                    <label class="control-label">Last Name <span style="color: red">*</span></label>
                    <input type="text" class="form-control" name="last_name" id="last_name" value="{{ old( 'last_name', isset($student->last_name) ? $student->last_name : '') }}" placeholder="Last Name Here" maxlength="150">
                    @error('last_name')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-6 fv-plugins-icon-container">
                <div class="form-group @error('parent_name') is-invalid @enderror">
                    <label class="control-label">Parent Name <span style="color: red">*</span></label>
                    <input type="text" class="form-control" name="parent_name" id="parent_name" value="{{ old( 'parent_name', isset($student->parent_name) ? $student->parent_name : '') }}" placeholder="Parent Name Here" maxlength="150">
                    @error('parent_name')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-6 fv-plugins-icon-container">
                <div class="form-group @error('parent_email') is-invalid @enderror">
                    <label class="control-label">Parent Email <span style="color: red">*</span></label>
                    <input type="email" class="form-control" name="parent_email" id="parent_email" value="{{ old( 'parent_email', isset($student->parent_email) ? $student->parent_email : '') }}" placeholder="Parent Email Here" maxlength="150">
                    @error('parent_email')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-6 fv-plugins-icon-container">
                <label class="control-label">Parent Mobile <span style="color: red">*</span></label>
                <div class="input-group input-group-merge  @error('parent_mobile') is-invalid @enderror">
                    <span class="input-group-text"></span>
                    <input type="text" id="parent_mobile" name="parent_mobile" value="{{ old( 'parent_mobile', isset($student->parent_mobile) ? $student->parent_mobile : '') }}" class="form-control" placeholder="... ... ....">
                    @error('parent_mobile')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="mb-6 col-md-6 form-password-toggle fv-plugins-icon-container  @error('gender') is-invalid @enderror">
                <label class="form-label" for="gender">Gender <span style="color: red">*</span></label>
                <select id="gender" name="gender" class="form-select">
                    <option disabled>Gender</option>
                    <option value="Male" {{ ($student->gender == 'Male') ? 'selected': '' }}>MALE</option>
                    <option value="Female" {{ ($student->gender == 'Female') ? 'selected': '' }}>FEMALE</option>
                </select>
                @error('status')
                    <div class="fv-plugins-message-container fv-plugins-message-container--enabled invalid-feedback">
                        {{ $message }}
                    </div>
                @enderror              
            </div>
            <div class="col-6 fv-plugins-icon-container">
                <div class="accordion stick-top accordion-custom-button course-content-fixed" id="daysContent">
                    <div class="accordion-item mb-0 active">
                        <div class="accordion-header" id="headingOne">
                        <button type="button" class="accordion-button" data-bs-toggle="collapse" data-bs-target="#days" aria-expanded="true" aria-controls="chapterOne">
                            <span class="d-flex flex-column">
                            <span class="h5 mb-0">Batches</span>
                            </span>
                        </button>
                        </div>
                        <div id="days" class="accordion-collapse collapse show" data-bs-parent="#daysContent" style="">
                        <div class="accordion-body py-4">
                            @foreach ($batches as $batch)
                            <div class="form-check d-flex align-items-center gap-1 mb-4">
                                <input class="form-check-input" name="batches[]" value="{{ $batch->id }}"
                                 type="checkbox" id="batch_{{ $batch->id }}" {{ in_array($batch->id, $studentBatches) ? 'checked': ''}}>
                                <label for="defaultCheck1" class="form-check-label ms-4">
                                <span class="mb-0 h6">{{ $batch->name }}</span>
                                </label>
                            </div>
                            @endforeach
                        </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 text-center">
                <button type="submit" class="btn btn-primary me-3 waves-effect waves-light">Submit</button>
                <a href="{{ route('students')}}" class="btn btn-label-secondary waves-effect">Cancel</a>
            </div>
        </form>
    </div>
</div>
<br/>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    var table;
    $(document).ready(function() {
      $('#chkHideCompletedLesson').change(function(){
        if($(this).is(":checked")) {
          $('.lesson.completed').hide();
        }
        else{
          $('.lesson').show();
        }
      });
    });
</script>
@endsection