@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('page-style')
<style type="text/css">
	.th-width{
		width: 25% !important;
	}
	h4.text-custom{
        font-weight: 500;
        color: #2cabe3;
    }
</style>
@endsection

@section('content')
<div class="d-flex flex-column flex-sm-row align-items-center justify-content-sm-between mb-6 text-center text-sm-start gap-2">
  <div class="mb-2 mb-sm-0">
    <h4 class="mb-1">Ticket Number #{{ old( 'number', isset($ticket->number) ? $ticket->number : '') }}</h4>
    <p class="mb-0">{{(isset($ticket->created_at) ? date(config('constant.date_format_new'),strtotime($ticket->created_at)) :'-')}}</p>
  </div>
</div>
<div class="row">
  <!-- Customer-detail Sidebar -->
  <div class="col-xl-5 col-lg-6 col-md-6 order-1 order-md-0">
    <!-- Customer-detail Card -->
    <div class="card mb-6">
      <div class="card-body pt-2">
        <div class="info-container">
          <h5 class="pb-4 border-bottom text-capitalize mt-6 mb-4">Details</h5>
          <ul class="list-unstyled mb-6">
            <li class="mb-2">
              <span class="h6 me-1">Title:</span>
              <span>{{ old( 'title', isset($ticket->title) ? $ticket->title : '') }}</span>
            </li>
            <li class="mb-2">
              <span class="h6 me-1">Priority:</span>
              <span>{{ $priority  }}</span>
            </li>
            <li class="mb-2">
              <span class="h6 me-1">Status:</span>
              <span>{{ $status }}</span>
            </li>
            @if($ticket->attachment)
            <li class="mb-2">
              <span class="h6 me-1">Attachment:</span>
              <span>
                <a download="" href="{{ asset(config('constant.ticket_attach').$ticket->attachment) }}">{{ $ticket->attachment }}</a>
              </span>
            </li>
            @endif
            <li class="mb-2">
              <span class="h6 me-1">Created By:</span>
              <span>{{(isset($ticket->_created_by) ? $ticket->_created_by->name :'-')}}</span>
            </li>
            <li class="mb-2">
              <span class="h6 me-1">Created At:</span>
              <span>{{(isset($ticket->created_at) ? date(config('constant.date_format_new'),strtotime($ticket->created_at)) :'-')}}</span>
            </li>
            <li class="mb-2">
              <span class="h6 me-1">Assigned To:</span>
              <span>{{(isset($ticket->_assigned_to) ? $ticket->_assigned_to->name :'-')}}</span>
            </li>
            <li class="mb-2">
              <span class="h6 me-1">Assigned At:</span>
              <span>{{(isset($ticket->assigned_at) ? date(config('constant.date_format_new'),strtotime($ticket->assigned_at)) :'-')}}</span>
            </li>
          </ul>
        </div>
      </div>
    </div>
    @if(Auth::user()->role_name == RoleAdmin || Auth::user()->role_name == RoleSuperAdmin)
    <div class="card mb-6">
      <div class="card-body pt-2">
        <form action="{{ route('tickets.statusUpdate') }}" name="assignform" id="assignform" method="POST">
          @csrf
          <input type="hidden" name="ticket_id" value="{{ $ticket->id }}">
          <div class="form-body">
            <div class="row">
              <div class="col-md-12">
                <div class="form-group @error('status') is-invalid @enderror">
                  <label class="control-label">Status</label>		
                  <select class="form-control" name="status" id="status">
                    <option value="">Please select status</option>

                    @if($ticket->status == TicketStatusCreated)
                    <option value="1">Assigned</option>
                    <option value="2">Closed</option>
                    @elseif($ticket->status == TicketStatusAssigned || $ticket->status == TicketStatusReopen)
                    <option value="2">Closed</option>
                    @endif
                    
                    @if($ticket->status == TicketStatusClosed)
                      <option value="3">Reopen</option>
                    @endif
                  </select>
                  @error('status')
                    <span class="invalid-feedback" role="alert">
                      {{ $message }}
                    </span>
                  @enderror
                </div>
              </div>
            </div>
            <div class="form-actions mt-2">
              <button type="submit" class="btn btn-success"> <i class="fa fa-check"></i> Save</button>
              <a href="{{ route('tickets.view', $ticket->id)}}" class="btn btn-default">Cancel</a>
            </div>
          </div>
        </form>
      </div>
    </div>
    <div class="card mb-6">
      <div class="card-body pt-2">
        <form action="{{ route('tickets.assign') }}" name="assignform" id="assignform" method="POST">
          @csrf
          <input type="hidden" name="ticket_id" value="{{ $ticket->id }}">
          <div class="form-body">
            <div class="row">
              <div class="col-md-12">
                <div class="form-group @error('assigned_to') is-invalid @enderror">
                  <label class="control-label">Assigned To</label>
                  <select class="form-control" name="assigned_to" id="assigned_to">
                    <option value="">Please select user</option>
                    @if(isset($users) && count($users)>0)
                      @foreach($users as $key => $value)
                        @php 
                          $roles = [];
                          foreach($value->roles as $role)
                            array_push($roles, $role->display_name);
                          
                        @endphp
                        <option value="{{$value->id}}">{{ $value->name }} ({{ implode(',', $roles) }}) ({{ $value->email }})</option>
                      @endforeach
                    @endif
                  </select>
                  @error('assigned_to')
                    <span class="invalid-feedback" role="alert">
                      {{ $message }}
                    </span>
                  @enderror
                </div>
              </div>
            </div>
            <div class="form-actions mt-2">
              <button type="submit" class="btn btn-success"> <i class="fa fa-check"></i> Save</button>
              <a href="{{ route('tickets.view', $ticket->id)}}" class="btn btn-default">Cancel</a>
            </div>
          </div>
        </form>
      </div>
    </div>
    @endif
  </div>
  <div class="col-xl-7 col-lg-6 col-md-6 order-0 order-md-1">
    <h5>Comments</h5>
    <div class="row text-nowrap">
      @foreach ($ticket->comments as $value)
      <div class="col-md-12 mb-5">
        <div class="card h-100">
          <div class="card-body">
            <div class="card-info">
              <h5 class="card-title mb-2">{{ $value->_created_by ? $value->_created_by->name : '' }}</h5>
              <div class="d-flex align-items-baseline gap-1">
                <p class="mb-0">{!! (isset($value->comments) ? $value->comments :'-') !!}</p>
              </div>
              <p class="mb-0" style="text-align: right;font-size: 12px;padding-top: 10px;">{{ date(config('constant.date_format_new'),strtotime($value->created_at))  }}</p>
            </div>
          </div>
        </div>
      </div>
      @endforeach
    </div>
    @if($ticket->status != TicketStatusClosed)
    <div class="row text-nowrap">
      <div class="col-md-12 mb-12">
        <div class="card h-100">
          <div class="card-body">
            <form action="{{ route('tickets.comment') }}" name="commentform" id="commentform" method="POST" >
              @csrf
              <input type="hidden" name="ticket_id" value="{{ $ticket->id }}">
              <div class="form-body">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group @error('comments') is-invalid @enderror">
                      <label class="control-label">Comment</label>
                      <textarea class="form-control" name="comments" id="note">{{ old('comments') }}</textarea>
                      @error('comments')
                        <span class="invalid-feedback" role="alert">
                          {{ $message }}
                        </span>
                      @enderror
                    </div>
                  </div>
                </div>
                <div class="form-actions mt-2">
                  <button type="submit" class="btn btn-success"> <i class="fa fa-check"></i> Save</button>
                  <a href="{{ route('tickets')}}" class="btn btn-default">Cancel</a>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
    @endif
  </div>
</div>
<br/>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    var table;
    $(document).ready(function() {
      $('#chkHideCompletedLesson').change(function(){
        if($(this).is(":checked")) {
          $('.lesson.completed').hide();
        }
        else{
          $('.lesson').show();
        }
      });
    });
</script>
@endsection