@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('content')
<div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0">Edit Tutor</h5>
    </div>
    <div class="card-body pt-4">
        <form action="{{ route('tutors.store') }}"  class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST" novalidate="novalidate">
            @csrf
            <input type="hidden" name="id" id="id" value="{{ isset($tutor->id) ? $tutor->id : '' }}">
            <div class="col-6 fv-plugins-icon-container">
                <div class="form-group @error('first_name') is-invalid @enderror">
                    <label class="control-label">First Name <span style="color: red">*</span></label>
                    <input type="text" class="form-control" name="first_name" id="first_name" value="{{ old( 'first_name', isset($tutor->first_name) ? $tutor->first_name : '') }}" placeholder="First Name Here" maxlength="150">
                    @error('first_name')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-6 fv-plugins-icon-container">
                <div class="form-group @error('last_name') is-invalid @enderror">
                    <label class="control-label">Last Name <span style="color: red">*</span></label>
                    <input type="text" class="form-control" name="last_name" id="last_name" value="{{ old( 'last_name', isset($tutor->last_name) ? $tutor->last_name : '') }}" placeholder="Last Name Here" maxlength="150">
                    @error('first_name')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="col-12 fv-plugins-icon-container">
                <div class="form-group @error('email') is-invalid @enderror">
                    <label class="control-label">Email <span style="color: red">*</span></label>
                    <input type="text" class="form-control" name="email" id="email" value="{{ old( 'email', isset($tutor->user) ? $tutor->user->email : '') }}" placeholder="Email Here" maxlength="150" readonly>
                    @error('email')
                        <span class="invalid-feedback" role="alert">
                            {{ $message }}
                        </span>
                    @enderror
                </div>
            </div>
            <div class="mb-6 col-md-6 form-password-toggle fv-plugins-icon-container  @error('status') is-invalid @enderror">
                <label class="form-label" for="status">Status <span style="color: red">*</span></label>
                <select id="status" name="status" class="form-select">
                    <option disabled>Status</option>
                    <option value="0" {{ ($tutor->status == 0) ? 'selected': '' }}>PENDING</option>
                    <option value="1" {{ ($tutor->status == 1) ? 'selected': '' }}>APPROVED</option>
                    <option value="2" {{ ($tutor->status == 2) ? 'selected': '' }}>REJECTED</option>
                    <option value="3" {{ ($tutor->status == 3) ? 'selected': '' }}>DORMENT</option>
                </select>
                @error('status')
                    <div class="fv-plugins-message-container fv-plugins-message-container--enabled invalid-feedback">
                        {{ $message }}
                    </div>
                @enderror              
            </div>
            <div class="col-12 text-center">
                <button type="submit" class="btn btn-primary me-3 waves-effect waves-light">Submit</button>
                <a href="{{ route('tutors')}}" class="btn btn-label-secondary waves-effect">Cancel</a>
            </div>
        </form>
    </div>
</div>
<br/>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    var table;
    $(document).ready(function() {
      $('#chkHideCompletedLesson').change(function(){
        if($(this).is(":checked")) {
          $('.lesson.completed').hide();
        }
        else{
          $('.lesson').show();
        }
      });
    });
</script>
@endsection