@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('page-style')
<style type="text/css">
	.th-width{
		width: 25% !important;
	}
	h4.text-custom{
        font-weight: 500;
        color: #2cabe3;
    }
</style>
@endsection

@section('content')

<div class="card mb-6">
  <div class="card-header d-flex flex-wrap justify-content-between gap-4">
    <div class="card-title mb-0 me-1">
      <h5 class="mb-0">{{ Auth::user()->role_name == RoleTutor ? 'My ' :'All '}} Lessons</h5>
      <p class="mb-0"></p>
    </div>
    <div class="d-flex justify-content-md-end align-items-center column-gap-6">
      <div class="form-check form-switch my-2 ms-2">
        <input type="checkbox" class="form-check-input" id="chkHideCompletedLesson">
        <label class="form-check-label text-nowrap mb-0" for="chkHideCompletedLesson">Hide Completed / Report Generated lessons</label>
      </div>
    </div>
  </div>
  <div class="card-body">
    <div class="row gy-6 mb-6">
      @foreach ( $lessons as $lesson )
        <div class="col-sm-6 col-lg-4 lesson {{ in_array($lesson->status, [LessonStatusCompleted, LessonStatusReportGenerated])  ? 'completed' : ''}}">
          <div class="card p-2 h-100 shadow-none border">
            <div class="rounded-2 text-center mb-4">
              <a href="{{ route('lessons.view', $lesson->id) }}"><img class="img-fluid" src="{{ asset('assets/img/pages/app-academy-tutor-'.rand(1, 6).'.png') }}" alt="lesson image"></a>
            </div>
            <div class="card-body p-4 pt-2">
              <div class="d-flex justify-content-between align-items-center mb-4">
                <span class="badge bg-label-primary">{{ $lesson->batch->name }}</span>
                @if($lesson->is_report_required && $lesson->status == LessonStatusReportGenerated)
                  <p class="d-flex align-items-center justify-content-center fw-medium gap-1 mb-0">
                      <a href="{{ route('lessons.reports.view', $lesson->id) }}">
                        <i class="menu-icon tf-icons ti ti-report" title="Report is required."></i>
                      </a>
                  </p>
                @endif
              </div>
              <a href="javascript:void(0);" class="h4 mb-2">{{ $lesson->name }}</a>
              <p>{{ $lesson->batch->name }}</p>
              <div class="row mb-4 g-3">
                <div class="col-12">
                  <div class="d-flex">
                    <div class="avatar flex-shrink-0 me-3">
                      <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-user ti-28px"></i></span>
                    </div>
                    <div>
                      <h6 class="mb-0 text-nowrap">{{ $lesson->batch->tutor->full_name }}</h6>
                      <small>Tutor</small>
                    </div>
                  </div>
                </div>
                <div class="col-12">
                  <div class="d-flex">
                    <div class="avatar flex-shrink-0 me-3">
                      <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-calendar-event ti-28px"></i></span>
                    </div>
                    <div>
                      <h6 class="mb-0 text-nowrap">{{ date(config('constant.date_format_new'), strtotime($lesson->start_date)) }}</h6>
                      <small>Date</small>
                    </div>
                  </div>
                </div>
                <div class="col-12">
                  <div class="d-flex">
                    <div class="avatar flex-shrink-0 me-3">
                      <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-clock ti-28px"></i></span>
                    </div>
                    <div>
                      <h6 class="mb-0 text-nowrap">{{ date_diff_in_min($lesson->start_date, $lesson->end_date)}}</h6>
                      <small>Duration</small>
                    </div>
                  </div>
                </div>
              </div>
              @php
                $status = get_lesson_status($lesson->status);
              @endphp
              <div class="d-flex flex-column flex-md-row gap-4 text-nowrap flex-wrap flex-md-nowrap flex-lg-wrap flex-xxl-nowrap">
                <a class="w-100 btn btn-label-{{ $status ['type']}} {{ $status ['type']}}-effect" href="javascript:void(0)">
                  <span>{{ $status['status']}}</span>
                </a>
              </div>
            </div>
          </div>
        </div>
      @endforeach
    </div>
  </div>
</div>
@endsection
@section('page-script')
@if (Session::has('alert-message'))
<script>
    Toast.fire({
        type: "{{ Session::get('alert-class', 'info') }}",
        title: "{{ Session::get('alert-message') }}"
    });
</script>
@endif
<script type="text/javascript">
    var table;
    $(document).ready(function() {
      $('#chkHideCompletedLesson').change(function(){
        if($(this).is(":checked")) {
          $('.lesson.completed').hide();
        }
        else{
          $('.lesson').show();
        }
      });
    });
</script>
@endsection