@extends('layouts.master')
@if(isset($page_title) && $page_title!='')
    @section('title', $page_title.' - '.config('app.name'))
@else
    @section('title', config('app.name'))
@endif
@section('page-style')
<style type="text/css">
	.th-width{
		width: 25% !important;
	}
	h4.text-custom{
        font-weight: 500;
        color: #2cabe3;
    }
</style>
@endsection

@section('content')
<div class="row fv-plugins-icon-container">
    <div class="col-md-12">
        <div class="nav-align-top">
            <ul class="nav nav-pills flex-column flex-md-row mb-6 gap-2 gap-lg-0">
                <li class="nav-item">
                    <a class="nav-link active waves-effect waves-light" href="javascript:void(0);"><i class="ti-sm ti ti-users me-1_5"></i> Account</a>
                </li>
            </ul>
        </div>
        <div class="card mb-6">
            <!-- Account -->
            <div class="card-body">
                <div class="d-flex align-items-start align-items-sm-center gap-6">
                    <img src="{{ asset('assets/img/avatars/user.png') }}" alt="user-avatar" class="d-block w-px-100 h-px-100 rounded" id="uploadedAvatar">
                </div>
            </div>
            <div class="card-body pt-4">
                <div class="row">
                    <div class="mb-4 col-md-6 fv-plugins-icon-container ">
                        <label for="name" class="form-label">Name: </label>
                        <span>{{ $user->name }}</span>
                    </div>
                    <div class="mb-4 col-md-6">
                        <label for="email" class="form-label">E-mail: </label>
                        <span>{{ $user->email }}</span>
                    </div>
                    <div class="mb-4 col-md-6">
                        <label for="role" class="form-label">Role: </label>
                        <span></span>
                    </div>
                </div>
            </div>
            <!-- /Account -->
        </div>
    </div>
</div>
@endsection