<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\Auth\SocialiteController;
use App\Http\Controllers\ForgotPasswordController;
use App\Http\Controllers\ResetPasswordController;
use Illuminate\Support\Facades\Route;
use App\Mail\BatchCreatedTutorMail;
use App\Models\Batches;
use Spatie\Permission\Models\Role;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::get('/', function (Request $request) {
    if (\Auth::check()) {
        return redirect('home');
    }
    return view('auth.login');
});
Route::get('/privacy-policy', function (Request $request) {
    return view('static.privacy');
});
Route::get('/testrolesync', function (Request $request) {
    $role = Role::where('name', 'admin')->whereNull('deleted_at')->first();
    $user = \App\Models\User::where('id', 2)->whereNull('deleted_at')->first();
    $user->syncRoles($role);
    echo 'Role Synched Success';exit;
});
Route::get('/cleared', function(Request $request) {
    Artisan::call('optimize:clear');
    
    return '<h1>Cleared</h1>';
 });
 
Route::get('/testmail', function (Request $request) {
    
   $batch                       = Batches::where('id',2)->first();
   Mail::to(trim("ankitit2015@gmail.com"))->send(new BatchCreatedTutorMail($batch));
   dd('mail sent');
});
Route::get('/home', function (Request $request) {
    if (\Auth::check()) {
        return redirect('home');
    }
    return view('auth.login');
});

Route::get('/home', 'HomeController@index')->name('home');

Route::middleware('guest')->group(function () {
    Route::get('auth/{provider}/redirect', [SocialiteController::class, 'loginSocial'])
        ->name('socialite.auth');
 
    Route::get('auth/google/callback', [SocialiteController::class, 'callbackGoogle'])
        ->name('socialite.callback.google');
        
    Route::get('auth/facebook/callback', [SocialiteController::class, 'callbackFB'])
        ->name('socialite.callback.facebook');
});

Route::group(['middleware' => ['web', 'auth']], function () {
    Route::get('/activities', 'HomeController@activities')->name('activities.index');
    

    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    
    Route::group(['prefix' => 'roles'], function () {
        Route::get('/', 'RoleController@index')->name('roles');
        Route::get('/add', 'RoleController@create')->name('roles.add');
        Route::post('/store', 'RoleController@store')->name('roles.store');
        Route::get('/view/{id}', 'RoleController@show')->name('roles.view');
        Route::get('/edit/{id}', 'RoleController@edit')->name('roles.edit');
        Route::post('/update/{id}', 'RoleController@update')->name('roles.update');
        Route::post('/destroy', 'RoleController@destroy')->name('roles.destroy');
        Route::get('roles/{roleId}/delete', [App\Http\Controllers\RoleController::class, 'destroy']);
        Route::get('roles/{roleId}/give-permissions', [App\Http\Controllers\RoleController::class, 'addPermissionToRole']);
        Route::put('roles/{roleId}/give-permissions', [App\Http\Controllers\RoleController::class, 'givePermissionToRole']);
    });
    
    Route::group(['prefix' => 'permissions'], function () {
        Route::get('/', 'PermissionController@index')->name('permissions');
        Route::get('/add', 'PermissionController@create')->name('permissions.add');
        Route::post('/store', 'PermissionController@store')->name('permissions.store');
        Route::get('/view/{id}', 'PermissionController@show')->name('permissions.view');
        Route::get('/edit/{id}', 'PermissionController@edit')->name('permissions.edit');
        Route::post('/update/{id}', 'PermissionController@update')->name('permissions.update');
        Route::post('/destroy', 'PermissionController@destroy')->name('permissions.destroy');
        Route::get('permissions/{permissionId}/delete', [App\Http\Controllers\PermissionController::class, 'destroy']);
    });
    
    Route::group(['prefix' => 'tutors'], function () {
        Route::get('/', 'TutorController@index')->name('tutors');
        Route::get('/add', 'TutorController@create')->name('tutors.add');
        Route::get('/lessons', 'TutorController@lessons')->name('tutors.lessons');
        Route::post('/store', 'TutorController@store')->name('tutors.store');
        Route::get('/view/{id}', 'TutorController@show')->name('tutors.view');
        Route::get('/edit/{id}', 'TutorController@edit')->name('tutors.edit');
        Route::post('/update/{id}', 'TutorController@update')->name('tutors.update');
        Route::post('/destroy', 'TutorController@destroy')->name('tutors.destroy');
        Route::get('/batches/{id}', 'TutorController@batches')->name('tutors.batches');
        Route::get('/schedule', 'TutorController@schedule')->name('tutors.schedule');
    });
    
    Route::group(['prefix' => 'admins'], function () {
        Route::get('/', 'AdminController@index')->name('admins');
        Route::get('/add', 'AdminController@create')->name('admins.add');
        Route::post('/store', 'AdminController@store')->name('admins.store');
        Route::get('/view/{id}', 'AdminController@show')->name('admins.view');
        Route::get('/edit/{id}', 'AdminController@edit')->name('admins.edit');
        Route::post('/update/{id}', 'AdminController@update')->name('admins.update');
        Route::post('/destroy', 'AdminController@destroy')->name('admins.destroy');
    });
    
    Route::group(['prefix' => 'students'], function () {
        Route::get('/', 'StudentController@index')->name('students');
        Route::get('/add', 'StudentController@create')->name('students.add');
        Route::post('/store', 'StudentController@store')->name('students.store');
        Route::get('/view/{id}', 'StudentController@show')->name('students.view');
        Route::get('/edit/{id}', 'StudentController@edit')->name('students.edit');
        Route::post('/update/{id}', 'StudentController@update')->name('students.update');
        Route::post('/destroy', 'StudentController@destroy')->name('students.destroy');
        Route::get('/batches/{id}', 'TutorController@batches')->name('students.batches');
    });
    
    Route::group(['prefix' => 'batches'], function () {
        Route::get('/', 'BatchController@index')->name('batches');
        Route::get('/add', 'BatchController@create')->name('batches.add');
        Route::post('/reminder', 'BatchController@feeReminder')->name('batches.reminder');
        Route::post('/store', 'BatchController@store')->name('batches.store');
        Route::get('/view/{id}', 'BatchController@show')->name('batches.view');
        Route::get('/edit/{id}', 'BatchController@edit')->name('batches.edit');
        Route::get('/lesson/{id}', 'BatchController@lesson')->name('batches.lesson');
        Route::post('/lesson/store', 'BatchController@storeLesson')->name('batches.lesson.store');
        Route::get('/lesson/timings/{id}', 'BatchController@lessonTimings')->name('batches.lesson.timings');
        Route::post('/lesson/timings/store', 'BatchController@storeLessonTimings')->name('batches.lesson.timings.store');
        Route::get('/student/{id}', 'BatchController@student')->name('batches.student');
        Route::post('/student/store', 'BatchController@storeStudent')->name('batches.student.store');
        Route::post('/update/{id}', 'BatchController@update')->name('batches.update');
        Route::post('/destroy', 'BatchController@destroy')->name('batches.destroy');
    });

    Route::group(['prefix' => 'users'], function () {
        Route::get('/', 'UserController@index')->name('users');
        Route::get('/view/{id}', 'UserController@show')->name('users.view');
    });
    
    Route::group(['prefix' => 'lessons'], function () {
        Route::get('/view/{id}', 'LessonController@show')->name('lessons.view');
        Route::get('/reports', 'LessonController@reports')->name('lessons.reports');
        Route::get('/reports/view/{id}', 'LessonController@viewReport')->name('lessons.reports.view');
        Route::post('/status', 'LessonController@status')->name('lessons.status');
        Route::post('/attendance', 'LessonController@attendance')->name('lessons.attendance');
        Route::post('/generateReport', 'LessonController@generateReport')->name('lessons.generateReport');
        Route::post('/destroy', 'LessonController@destroy')->name('lessons.destroy');
    });

    Route::group(['prefix' => 'payment-orders'], function () {
        Route::get('/', 'PaymentOrderController@index')->name('payment-orders');
        Route::get('/add', 'PaymentOrderController@create')->name('payment-orders.add');
        Route::post('/store', 'PaymentOrderController@store')->name('payment-orders.store');
        Route::get('/view/{id}', 'PaymentOrderController@show')->name('payment-orders.view');
        Route::get('/edit/{id}', 'PaymentOrderController@edit')->name('payment-orders.edit');
        Route::post('/update/{id}', 'PaymentOrderController@update')->name('payment-orders.update');
        Route::post('/destroy', 'PaymentOrderController@destroy')->name('payment-orders.destroy');
        Route::post('/paid', 'PaymentOrderController@paid')->name('payment-orders.paid');
        Route::get('/pdf/{id}', 'PaymentOrderController@pdfReport')->name('payment-orders.pdf');
        Route::get('/mail/{id}/{user_id}', 'PaymentOrderController@mailPdfReport')->name('payment-orders.mail');

    });

    Route::group(['prefix' => 'tickets'], function () {
        Route::get('/', 'TicketController@index')->name('tickets');
        Route::get('/add', 'TicketController@create')->name('tickets.add');
        Route::post('/store', 'TicketController@store')->name('tickets.store');
        Route::get('/view/{id}', 'TicketController@show')->name('tickets.view');
        Route::get('/edit/{id}', 'TicketController@edit')->name('tickets.edit');
        Route::post('/assign', 'TicketController@assign')->name('tickets.assign');
        Route::post('/comment', 'TicketController@comment')->name('tickets.comment');
        Route::post('/statusUpdate', 'TicketController@statusUpdate')->name('tickets.statusUpdate');
    });
    
    Route::get('/profile', 'ProfileController@showProfile')->name('profile');
    Route::post('/profile/update', 'ProfileController@profileUpdate')->name('profile.submit');
    Route::get('/profile/password', 'ProfileController@showPassword')->name('profile.password');
    Route::post('/profile/password/update', 'ProfileController@passwordUpdate')->name('profile.password.submit');

    //meeting routes
    Route::post('create-meeting', [App\Http\Controllers\MeetingController::class, 'createMeeting']);
    Route::post('delete-meeting', [App\Http\Controllers\MeetingController::class, 'deleteMeeting']);
    Route::post('edit-meeting', [App\Http\Controllers\MeetingController::class, 'editMeeting']);
    Route::get('languages/{locale}', [App\Http\Controllers\MeetingController::class, 'setLocale'])->name('language');
    Route::get('instant/{id}/{date}', [App\Http\Controllers\MeetingController::class, 'instant'])->name('instant');
    Route::get('/check-details', [App\Http\Controllers\MeetingController::class, 'checkDetails']);

    Route::get('meeting/{id}', [App\Http\Controllers\MeetingController::class, 'meeting'])->name('meeting');
    Route::get('/pages/{id}', [App\Http\Controllers\MeetingController::class, 'showPage'])->name('pages.show');
    Route::post('get-details', [App\Http\Controllers\MeetingController::class, 'getDetails']);
    Route::post('send-invite', [App\Http\Controllers\MeetingController::class, 'sendInvite']);
    Route::get('get-invites', [App\Http\Controllers\MeetingController::class, 'getInvites']);
    Route::post('check-meeting', [App\Http\Controllers\MeetingController::class, 'checkMeeting']);
    Route::post('check-meeting-password', [App\Http\Controllers\MeetingController::class, 'checkMeetingPassword']);
    Route::post('join-meeting', [App\Http\Controllers\MeetingController::class, 'joinMeeting']);
    Route::post('leave-meeting', [App\Http\Controllers\MeetingController::class, 'leaveMeeting']);
    Route::post('leave-meeting-all', [App\Http\Controllers\MeetingController::class, 'leaveMeetingForAll']);
    Route::post('upload-recording', [App\Http\Controllers\MeetingController::class, 'uploadRecording']);
});
Route::group(['prefix' => 'bulk-mail',], function () {
    Route::get('/', [App\Http\Controllers\BulkMailController::class, 'showForm'])->name('bulk.mail');
    Route::post('/send', [App\Http\Controllers\BulkMailController::class, 'send'])->name('bulk.mail.send');
});
Route::get('widget', [App\Http\Controllers\MeetingController::class, 'widget']);
 
require __DIR__.'/auth.php';


