import { EnhancedEventEmitter } from './enhancedEvents';
import type { DataProducer, DataProducerType, DataProducerDump, DataProducerStat, DataProducerEvents, DataProducerObserver } from './DataProducerTypes';
import { Channel } from './Channel';
import type { TransportInternal } from './Transport';
import type { SctpStreamParameters } from './sctpParametersTypes';
import type { AppData } from './types';
import * as FbsDataProducer from './fbs/data-producer';
type DataProducerInternal = TransportInternal & {
    dataProducerId: string;
};
type DataProducerData = {
    type: DataProducerType;
    sctpStreamParameters?: SctpStreamParameters;
    label: string;
    protocol: string;
};
export declare class DataProducerImpl<DataProducerAppData extends AppData = AppData> extends EnhancedEventEmitter<DataProducerEvents> implements DataProducer {
    #private;
    constructor({ internal, data, channel, paused, appData, }: {
        internal: DataProducerInternal;
        data: DataProducerData;
        channel: Channel;
        paused: boolean;
        appData?: DataProducerAppData;
    });
    get id(): string;
    get closed(): boolean;
    get type(): DataProducerType;
    get sctpStreamParameters(): SctpStreamParameters | undefined;
    get label(): string;
    get protocol(): string;
    get paused(): boolean;
    get appData(): DataProducerAppData;
    set appData(appData: DataProducerAppData);
    get observer(): DataProducerObserver;
    close(): void;
    transportClosed(): void;
    dump(): Promise<DataProducerDump>;
    getStats(): Promise<DataProducerStat[]>;
    pause(): Promise<void>;
    resume(): Promise<void>;
    send(message: string | Buffer, ppid?: number, subchannels?: number[], requiredSubchannel?: number): void;
    private handleWorkerNotifications;
    private handleListenerError;
}
export declare function dataProducerTypeToFbs(type: DataProducerType): FbsDataProducer.Type;
export declare function dataProducerTypeFromFbs(type: FbsDataProducer.Type): DataProducerType;
export declare function parseDataProducerDumpResponse(data: FbsDataProducer.DumpResponse): DataProducerDump;
export {};
//# sourceMappingURL=DataProducer.d.ts.map