import { EnhancedEventEmitter } from './enhancedEvents';
import type { Producer, ProducerType, ProducerScore, ProducerDump, ProducerStat, ProducerTraceEventType, ProducerEvents, ProducerObserver } from './ProducerTypes';
import { Channel } from './Channel';
import type { TransportInternal } from './Transport';
import type { MediaKind, RtpParameters } from './rtpParametersTypes';
import type { AppData } from './types';
import * as FbsProducer from './fbs/producer';
import * as FbsRtpParameters from './fbs/rtp-parameters';
type ProducerInternal = TransportInternal & {
    producerId: string;
};
type ProducerData = {
    kind: MediaKind;
    rtpParameters: RtpParameters;
    type: ProducerType;
    consumableRtpParameters: RtpParameters;
};
export declare class ProducerImpl<ProducerAppData extends AppData = AppData> extends EnhancedEventEmitter<ProducerEvents> implements Producer {
    #private;
    constructor({ internal, data, channel, appData, paused, }: {
        internal: ProducerInternal;
        data: ProducerData;
        channel: Channel;
        appData?: ProducerAppData;
        paused: boolean;
    });
    get id(): string;
    get closed(): boolean;
    get kind(): MediaKind;
    get rtpParameters(): RtpParameters;
    get type(): ProducerType;
    get consumableRtpParameters(): RtpParameters;
    get paused(): boolean;
    get score(): ProducerScore[];
    get appData(): ProducerAppData;
    set appData(appData: ProducerAppData);
    get observer(): ProducerObserver;
    /**
     * Just for testing purposes.
     *
     * @private
     */
    get channelForTesting(): Channel;
    close(): void;
    transportClosed(): void;
    dump(): Promise<ProducerDump>;
    getStats(): Promise<ProducerStat[]>;
    pause(): Promise<void>;
    resume(): Promise<void>;
    enableTraceEvent(types?: ProducerTraceEventType[]): Promise<void>;
    send(rtpPacket: Buffer): void;
    private handleWorkerNotifications;
    private handleListenerError;
}
export declare function producerTypeFromFbs(type: FbsRtpParameters.Type): ProducerType;
export declare function producerTypeToFbs(type: ProducerType): FbsRtpParameters.Type;
export declare function parseProducerDump(data: FbsProducer.DumpResponse): ProducerDump;
export {};
//# sourceMappingURL=Producer.d.ts.map