import { EnhancedEventEmitter } from './enhancedEvents';
import type { Worker, WorkerSettings } from './WorkerTypes';
import { workerBin } from './Worker';
import type { RtpCapabilities } from './rtpParametersTypes';
import type * as types from './types';
/**
 * Expose all types.
 */
export { types };
/**
 * Expose mediasoup version.
 */
export declare const version: string;
export type Observer = EnhancedEventEmitter<ObserverEvents>;
export type ObserverEvents = {
    newworker: [Worker];
};
declare const observer: Observer;
/**
 * Observer.
 */
export { observer };
/**
 * Full path of the mediasoup-worker binary.
 */
export { workerBin };
/**
 * Set event listeners for mediasoup generated logs. If called with no arguments
 * then no events will be emitted.
 *
 * @example
 * ```ts
 * mediasoup.setLogEventListeners({
 *   ondebug: undefined,
 *   onwarn: (namespace: string, log: string) => {
 *     MyEnterpriseLogger.warn(`${namespace} ${log}`);
 *   },
 *   onerror: (namespace: string, log: string, error?: Error) => {
 *     if (error) {
 *       MyEnterpriseLogger.error(`${namespace} ${log}: ${error}`);
 *     } else {
 *       MyEnterpriseLogger.error(`${namespace} ${log}`);
 *     }
 *   }
 * });
 * ```
 */
export declare function setLogEventListeners(listeners?: types.LogEventListeners): void;
/**
 * Create a Worker.
 */
export declare function createWorker<WorkerAppData extends types.AppData = types.AppData>({ logLevel, logTags, rtcMinPort, rtcMaxPort, dtlsCertificateFile, dtlsPrivateKeyFile, libwebrtcFieldTrials, disableLiburing, appData, }?: WorkerSettings<WorkerAppData>): Promise<Worker<WorkerAppData>>;
/**
 * Get a cloned copy of the mediasoup supported RTP capabilities.
 */
export declare function getSupportedRtpCapabilities(): RtpCapabilities;
/**
 * Expose parseScalabilityMode() function.
 */
export { parseScalabilityMode } from './scalabilityModesUtils';
/**
 * Expose extras module.
 */
export * as extras from './extras';
//# sourceMappingURL=index.d.ts.map