<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page . ' | ' . $meeting->title); ?>

<?php $__env->startSection('style'); ?>
    <link href="<?php echo e(asset('assets/meeting/css/meeting.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container meeting-details">
        <canvas id="audioOnly" hidden></canvas>
        <div class="row h-100 justify-content-center align-items-center">
            <div class="col-lg-7 video-detail">
                <div class="video-Section">
                    <video id="previewVideo" class="cam" autoplay playsinline muted></video>
                    <div class="cameraText"><?php echo e(__('Camera is off')); ?></div>
                    <div class="video-controls">
                        <ul>
                            <li id="toggleAudioPreview" class="disabled" data-toggle="tooltip" data-placement="top"
                                title="<?php echo e(__('Toggle audio')); ?>">
                                <em class="fa fa-microphone-slash"></em>
                            </li>
                            <li id="toggleVideoPreview" class="disabled" data-toggle="tooltip" data-placement="top"
                                title="<?php echo e(__('Toggle video')); ?>">
                                <em class="fa fa-video-slash"></em>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="text-show" style="color: red;"></div>
            </div>
            <div class="col-lg-5">
                <h3><strong>Welcome</strong> <?php echo e($meeting->username); ?></h3><br>
                <div class="card mb-0">
                    <div class="card-header">
                        <h5><?php echo e($meeting->title); ?></h5>
                    </div>
                    <div class="card-body">
                        <?php if($meeting->timeLimit == -1): ?>
                            <!--<div class="ribbon-wrapper ribbon-xl">
                                <div class="ribbon bg-primary" title="<?php echo e(__('Time Limit')); ?>">
                                    <?php echo e(__('Unlimited') . ' ' . __('Minutes')); ?>

                                </div>
                            </div>-->
                        <?php else: ?>
                            <!--<div class="ribbon-wrapper ribbon-lg">
                                <div class="ribbon bg-primary" title="<?php echo e(__('Time Limit')); ?>">
                                    <?php echo e($meeting->timeLimit . ' ' . __('Minutes')); ?>

                                </div>
                            </div>-->
                        <?php endif; ?>
                        <form id="passwordCheck">
                            <div class="form-group">
                                <h6 title="Tutor"><i class="fa fa-user mr-1"></i> Tutor: <?php echo e($meeting->tutor ? $meeting->tutor : '-'); ?></h6>
                            </div>
                            <?php if(getSetting('AUTH_MODE') == 'enabled'): ?>
                                <div class="form-group">
                                    <h6 title="Lesson Start Date & Time"><i class="fa fa-calendar mr-1"></i>
                                        <?php echo e($meeting->start_date ? $meeting->start_date : '-'); ?></h6>
                                </div>
                                <div class="form-group">
                                    <h6 title="Duration"><i class="fa fa-clock mr-1"></i>
                                        <?php echo e($meeting->duration ? $meeting->duration : '-'); ?></h6>
                                </div>
                                <div class="form-group">
                                    <h6 title="Timezone"><i class="fa fa-globe mr-1"></i>
                                        <?php echo e($meeting->timezone ? $meeting->timezone : '-'); ?></h6>
                                </div>
                            <?php endif; ?>
                            <div class="form-group">
                                <p class="mb-1 meetDesc"><?php echo e($meeting->description ? $meeting->description : '-'); ?></p>
                            </div>

                            <div class="form-group row" <?php if(Auth::check()): ?> hidden <?php endif; ?>>
                                <div class="col-12 col-md-10 offset-md-1">
                                    <input type="text" id="username" class="form-control"
                                        value="<?php echo e($meeting->username); ?>" placeholder="<?php echo e(__('Enter your name')); ?>"
                                        maxlength="8" />
                                </div>
                            </div>

                            <?php if($meeting->password): ?>
                                <div class="form-group row">
                                    <div class="col-12 col-md-10 offset-md-1">
                                        <input id="password" type="text" class="form-control" name="password"
                                            placeholder="<?php echo e(__('Enter meeting password')); ?>" maxlength="8" required />
                                        <input type="hidden" name="id" value="<?php echo e($meeting->id); ?>" />
                                    </div>
                                </div>
                            <?php endif; ?>

                            <div class="form-group row mb-0">
                                <div class="col-md-12 text-center">
                                    <button class="btn btn-primary" id="joinMeeting" data-toggle="tooltip"
                                        data-placement="top" title="<?php echo e(__('Join Meeting')); ?>" type="submit"
                                        disabled><?php echo e(__('Join')); ?></button>
                                    <button class="btn btn-info d-none" type="button" data-toggle="modal"
                                        data-target="#shortcutInfo" data-toggle="tooltip" data-placement="top"
                                        title="<?php echo e(__('Shortcut Keys information')); ?>"><i class="fa fa-info"></i></button>
                                    <button class="btn btn-secondary add d-none" type="button" data-toggle="tooltip"
                                        data-placement="top" title="<?php echo e(__('Share Link')); ?>"><i
                                            class="fa fa-share-alt"></i></button>
                                </div>
                                <div id="error">
                                    <p><?php echo e(__('Could not connect to the server, please try refreshing the page')); ?></p>

                                    <?php if($meeting->isAdmin): ?>
                                        <a href="/signaling" target="_blank"><span class="badge badge-warning p-2"><i
                                                    class="fa fa-exclamation-triangle"></i>
                                                <?php echo e(__('Troubleshooting steps (Visible to the admin only)')); ?></span></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid meeting-section">
        <div class="row">
            <div id="videos">
                <div class="videoContainer">
                    <div class="local-user-frame"></div>
                    <audio id="localAudio" autoplay muted></audio>
                    <video id="localVideo" class="cam" autoplay playsinline></video>
                    <div class="local-user-character"></div>
                    <span class="local-user-name"><?php echo e(__('You')); ?>

                        <i class='fas fa-crown moderator-icon' title='<?php echo e(__('Tutor')); ?>' <?php if(!$meeting->isTutor): ?> style="display: none" <?php endif; ?>></i>
                    </span>
                    <p class="user-initial"></p>
                </div>
                <div id="screenContainer" class="videoContainer">
                    <a href="javascript:void(0)" class="btn-expand"><i class="fas fa-expand"></i></a>
                    <audio id="localScreenAudio" autoplay muted></audio>
                    <video id="localScreenVideo" autoplay playsinline></video>
                    <span class="local-user-name"><?php echo e(__('Your screen')); ?></span>
                </div>
            </div>
            <div id="whiteboardSection" class="<?php echo e(!$meeting->isTutor ? 'not-allowed' : ''); ?>"></div>
            <div id="chatSection">
                <div class="chat-box">
                    <div class="chat-header">
                        <?php echo e(__('Chat')); ?>

                        <i class="fas fa-times close-panel"></i>
                    </div>
                    <div class="chat-body">
                        <div class="empty-chat-body">
                            <i class="fa fa-comments chat-icon"></i>
                        </div>
                    </div>
                    <div class="chat-footer">
                        <form id="chatForm">
                            <div class="input-group">
                                <input type="text" id="messageInput" class="form-control note-input"
                                    placeholder="<?php echo e(__('Type a message')); ?>" autocomplete="off" maxlength="250" />
                                <div class="input-group-append">
                                    <button id="sendMessage" class="btn btn-outline-secondary" type="submit"
                                        title="<?php echo e(__('Send')); ?>">
                                        <i class="far fa-paper-plane"></i>
                                    </button>
                                    <button id="selectFile" class="btn btn-outline-secondary"
                                        title="<?php echo e(__('Attach File')); ?>" type="button">
                                        <i class="fas fa-paperclip"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                        <input type="file" name="file" id="file" data-max="50" hidden />
                    </div>
                </div>
            </div>
        </div>

        <div class="meeting-info text-center">
            <span id="meetingIdInfo" class="text-center"></span>
            <span id="timer" class="text-center"></span>
        </div>

        <div class="emoji-container"></div>
        <div class="emoji-list btn-group" role="group" >
            
        </div>
        <div class="meeting-options <?php echo e(!$meeting->isTutor ? 'small' : ''); ?>">
            <button class="btn-toggle"><i class="fas fa-angle-double-up"></i></button>
            <div class="btn-group" role="group" aria-label="Basic example">
                <button class="btn meeting-option" title="<?php echo e(__('Participants')); ?>" data-toggle="modal"
                    data-target="#participantList" id="showParticipantList">
                    <i class="fas fa-users"></i>
                </button>
                <button class="btn meeting-option" title="<?php echo e(__('Chat')); ?>" id="openChat">
                    <i class="far fa-comment-alt"></i>
                </button>
                <button class="btn meeting-option" title="<?php echo e(__('Mute/Unmute Mic')); ?>" id="toggleMic">
                    <i class="fa fa-microphone"></i>
                </button>
                <button class="btn meeting-option" title="<?php echo e(__('On/Off Camera')); ?>" id="toggleVideo">
                    <i class="fa fa-video"></i>
                </button>
                <?php if(!$meeting->isTutor): ?>
                <button class="btn meeting-option" title="<?php echo e(__('Raise Hand')); ?>" id="raiseHand">
                    <i class="fa fa-hand-paper"></i>
                </button>
                <?php endif; ?>
                <?php if($meeting->isTutor): ?>
                <div class="d-inline">
                    <button class="btn meeting-option dropdown-toggle" type="button" data-toggle="dropdown" id="openMotivators">
                        <i class="far fa-smile"></i>
                    </button>
                    <div class="dropdown-menu motivator-dropdown" aria-labelledby="openMotivators" >
                        <a class="dropdown-item text-decoration-none text-dark btn-emoji" href="javascript:void(0);" aria-label="Heart emoji" data-sound="lovely.mp3"><span>💖</span> <?php echo e(__('Lovely')); ?></a>
                        <a class="dropdown-item text-decoration-none text-dark btn-emoji" href="javascript:void(0);" aria-label="Thumbs up emoji" data-sound="thumbs-up.mp3"><span>👍</span> <?php echo e(__('Thumbs-up')); ?></a>
                        <a class="dropdown-item text-decoration-none text-dark btn-emoji" href="javascript:void(0);" aria-label="Party popper emoji" data-sound="celebrate.mp3"><span>🎉</span> <?php echo e(__('Celebrate')); ?></a>
                        <a class="dropdown-item text-decoration-none text-dark btn-emoji" href="javascript:void(0);" aria-label="Clapping hands emoji" data-sound="claps.mp3"><span>👏</span> <?php echo e(__('Clap')); ?></a>
                        <a class="dropdown-item text-decoration-none text-dark btn-emoji" href="javascript:void(0);" aria-label="Laughing emoji" data-sound="laugh.mp3"><span>😂</span> <?php echo e(__('Laugh')); ?></a>
                        <a class="dropdown-item text-decoration-none text-dark btn-emoji" href="javascript:void(0);" aria-label="Surprised face emoji" data-sound="shocking.mp3"><span>😯</span> <?php echo e(__('Shocking')); ?></a>
                        <a class="dropdown-item text-decoration-none text-dark btn-emoji" href="javascript:void(0);" aria-label="Crying face emoji" data-sound="crying.mp3"><span>😢</span> <?php echo e(__('Crying')); ?></a>
                        <a class="dropdown-item text-decoration-none text-dark btn-emoji" href="javascript:void(0);" aria-label="Thinking face emoji" data-sound="hmm.mp3"><span>🤔</span> <?php echo e(__('Thinking')); ?></a>
                        <a class="dropdown-item text-decoration-none text-dark btn-emoji" href="javascript:void(0);" aria-label="Thumbs down emoji" data-sound="thumbs-down.mp3"><span>👎</span> <?php echo e(__('Thumbs-Down')); ?></a>
                    </div>
                </div>
                <div class="d-inline" id="moreOptions">
                    <button class="btn meeting-option dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-ellipsis-v"></i>
                    </button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                        <a class="dropdown-item text-decoration-none text-dark" href="javascript:void(0);" id="openCharacters"><i class="fas fa-tv"></i> <?php echo e(__('Characters')); ?></a>
                        <a class="dropdown-item text-decoration-none text-dark" href="javascript:void(0);" id="whiteboard"><i class="fa fa-chalkboard"></i> <?php echo e(__('Whiteboard')); ?></a>
                        <a class="dropdown-item text-decoration-none text-dark" href="javascript:void(0);" id="openFrames"><i class="fas fa-vector-square"></i></i> <?php echo e(__('Frames')); ?></a>
                        <a class="dropdown-item text-decoration-none text-dark" href="javascript:void(0);" id="screenShare"><i class="fa fa-desktop"></i> <?php echo e(__('Start/Stop ScreenShare')); ?></a>
                        <a class="dropdown-item text-decoration-none text-dark" href="javascript:void(0);" id="muteAll"><i class="fa fa-users"></i> <?php echo e(__('Mute/Unmute All')); ?></a>
                        <a class="dropdown-item text-decoration-none text-dark" href="javascript:void(0);" id="toggleFullscreen"><i class="fas fa-expand"></i> <?php echo e(__('Fullscreen')); ?></a>
                    </div>
                </div>
                <?php else: ?>
                  <a class="dropdown-item text-decoration-none text-dark d-none" href="javascript:void(0);" id="whiteboard"><?php echo e(__('Whiteboard')); ?></a>
                <?php endif; ?>
                <button class="btn btn-danger" title="<?php echo e(__('Leave Meeting')); ?>" id="leave">
                    <i class="fas fa-phone-alt"></i>
                </button>
                <!--<button class="btn meeting-option hide openSettings" title="<?php echo e(__('Open Settings')); ?>">
                    <i class="fa fa-cog"></i>
                </button>--> 
            </div>
        </div>
    </div>

    <div class="modal fade" id="previewModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="previewModalLabel"><?php echo e(__('File Preview')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span >&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <img id="previewImage" src="" />
                    <p id="previewFilename"></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                    <button type="button" id="sendFile" class="btn btn-primary"><?php echo e(__('Send')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="displayModal" tabindex="-1" role="dialog" >
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="displayModalLabel"><?php echo e(__('File Display')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span >&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <img id="displayImage" src="" />
                    <p id="displayFilename"></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    <button type="button" id="downloadFile" class="btn btn-primary"><?php echo e(__('Download')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="settings" tabindex="-1" role="dialog" >
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="settingsLabel"><?php echo e(__('Settings')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span >&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group row">
                        <div class="col-lg-3 col-md-4 text-left">
                            <label for="videoQualitySelect"><?php echo e(__('Video quality')); ?> </label>
                        </div>
                        <div class="col-lg-9 col-md-8">
                            <select id="videoQualitySelect" class="form-control">
                                <!--
                                    <option id="QVGA" data-width="320" data-height="240"><?php echo e(__('QVGA')); ?></option>
                                    <option id="VGA" data-width="640" data-height="480"><?php echo e(__('VGA')); ?></option>
                                -->
                                <option id="HD" data-width="1280" data-height="720"><?php echo e(__('HD')); ?></option>
                                <option id="FHD" data-width="1920" data-height="1080"><?php echo e(__('FHD')); ?></option>
                                <option id="4K" data-width="3840" data-height="2160"><?php echo e(__('4K')); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-lg-3 col-md-4 text-left">
                            <label for="audioSource"><?php echo e(__('Audio input source')); ?> </label>
                        </div>
                        <div class="col-lg-9 col-md-8">
                            <select id="audioSource" class="form-control"></select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-lg-3 col-md-4 text-left">
                            <label for="videoSource"><?php echo e(__('Video source')); ?> </label>
                        </div>
                        <div class="col-lg-9 col-md-8">
                            <select id="videoSource" class="form-control"></select>
                        </div>
                    </div>

                    <div class="form-group row">
                        <div class="col-lg-3 col-md-4 text-left">
                            <label for="videoSource"><?php echo e(__('Recording preference')); ?> </label>
                        </div>
                        <div class="col-lg-9 col-md-8">
                            <select id="recordingPreference" class="form-control">
                                <option value="with"><?php echo e(__('With whiteboard')); ?></option>
                                <option value="without"><?php echo e(__('Without whiteboard')); ?></option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="shortcutInfo" tabindex="-1" role="dialog"
        >
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="shortcutInfoLabel"><?php echo e(__('Settings')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span >&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table class="table table-borderless">
                        <thead>
                            <tr>
                                <th scope="col"><?php echo e(__('Shortcut Key')); ?></th>
                                <th scope="col"><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <th scope="row">C</th>
                                <td><?php echo e(__('Chat')); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">F</th>
                                <td><?php echo e(__('Attach File')); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">A</th>
                                <td><?php echo e(__('Mute/Unmute Audio')); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">L</th>
                                <td><?php echo e(__('Leave Meeting')); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">V</th>
                                <td><?php echo e(__('On/Off Video')); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">S</th>
                                <td><?php echo e(__('Screen Share')); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="participantList" tabindex="-1" role="dialog"
        >
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="participantListLabel"><?php echo e(__('Participants')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span >&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table class="table table-borderless">
                        <thead>
                            <tr>
                                <th scope="col"><?php echo e(__('#')); ?></th>
                                <th scope="col"><?php echo e(__('Name')); ?></th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody id="participantListBody">
                            <tr>
                                <th scope="row"></th>
                                <td><?php echo e(__('You')); ?></td>
                                <td></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="frameModal" tabindex="-1" role="dialog" >
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div id="frame-container" class="cols">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="characterModal" tabindex="-1" role="dialog" >
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div id="character-container" class="cols">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <style>
        #moreOptions {
            display: none;
        }
    </style>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        const userInfo = {
            username: htmlEscape(username.value),
            meetingId: "<?php echo e($meeting->meeting_id); ?>"
        };

        const passwordRequired = "<?php echo e(!!$meeting->password); ?>";
        const lessonId = "<?php echo e($meeting->lessonId); ?>";
        const isTutor = "<?php echo e($meeting->isTutor); ?>";
        const userId = "<?php echo e($meeting->userId); ?>";
        const meetingTitle = "<?php echo e($meeting->title); ?>";
        const batchName = "<?php echo e($meeting->batch); ?>";
        const lessonName = "<?php echo e($meeting->lesson); ?>";
        const meetingId = "<?php echo e($meeting->id); ?>";
        const timeLimit = "<?php echo e($meeting->timeLimit == -1 ? 9999 : $meeting->timeLimit); ?>";
        const userLimit = "<?php echo e($meeting->userLimit == -1 ? 9999 : $meeting->userLimit); ?>";
        const features = JSON.parse("<?php echo e(json_encode($meeting->features)); ?>".replace(/&quot;/g, '"'));
        Object.freeze(features);
    </script>
    <script src="<?php echo e(asset('assets/meeting/js/socket.io.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/meeting/js/bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/meeting/js/easytimer.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/meeting/js/siofu.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/meeting/js/MultiStreamsMixer.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/meeting/js/opentok-layout.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/meeting/js/canvas-designer-widget.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/meeting/js/meeting.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.meeting.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/thereadernest/public_html/resources/views/meeting/home.blade.php ENDPATH**/ ?>