<?php $__env->startSection('content'); ?>
<div class="container">
    <h2>Send Bulk Email</h2>
    <form action="<?php echo e(route('bulk.mail.send')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="mb-3">
            <label for="recipient_type" class="form-label">Send To</label>
            <select class="form-control" id="recipient_type" name="recipient_type" required>
                <option value="student">Students</option>
                <option value="tutor">Tutors</option>
            </select>
        </div>
        <div class="mb-3" id="students-dropdown">
            <label for="students" class="form-label">Select Students</label>
            <select class="form-control" id="students" name="students[]" multiple>
                <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($student->user_id); ?>"><?php echo e($student->full_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="mb-3" id="tutors-dropdown" style="display:none;">
            <label for="tutors" class="form-label">Select Tutors</label>
            <select class="form-control" id="tutors" name="tutors[]" multiple>
                <?php $__currentLoopData = $tutors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tutor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($tutor->user_id); ?>"><?php echo e($tutor->full_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="mb-3">
            <label for="subject" class="form-label">Subject</label>
            <input type="text" class="form-control" id="subject" name="subject" required>
        </div>
        <div class="mb-3">
            <label for="message" class="form-label">Message</label>
            <textarea class="form-control" id="message" name="message" rows="5" required></textarea>
        </div>
        <button type="submit" class="btn btn-primary">Send Email</button>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
<!-- Select2 CSS & JS from CDN for multi-select -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('#students').select2({
            placeholder: 'Select students',
            width: '100%'
        });
        $('#tutors').select2({
            placeholder: 'Select tutors',
            width: '100%'
        });
        $('#recipient_type').on('change', function() {
            if ($(this).val() === 'student') {
                $('#students-dropdown').show();
                $('#tutors-dropdown').hide();
            } else {
                $('#students-dropdown').hide();
                $('#tutors-dropdown').show();
            }
        }).trigger('change');
    });
</script>
<?php if(Session::has('alert-message')): ?>
<script>
    Toast.fire({
        type: "<?php echo e(Session::get('alert-class', 'info')); ?>",
        title: "<?php echo e(Session::get('alert-message')); ?>"
    });
</script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u384437918/domains/thereadernest.in/public_html/resources/views/bulk_mail.blade.php ENDPATH**/ ?>