

<?php if(isset($page_title) && $page_title != ''): ?>
    <?php $__env->startSection('title', $page_title . ' - ' . config('app.name')); ?>
<?php else: ?>
    <?php $__env->startSection('title', config('app.name')); ?>
<?php endif; ?>
<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
  <?php if(Auth::user()->role_name != RoleStudent): ?>
  <div class="card bg-transparent shadow-none my-6 border-0">
      <div class="card-body row p-0 pb-6 g-6">
          <div class="col-12 <?php echo e(Auth::user()->role_name != RoleTutor ? 'col-lg-8' : 'col-lg-5'); ?> card-separator">
            <h5 class="mb-5">Welcome back,<span class="h4"> <?php echo e(Auth::user()->name); ?> 👋🏻</span></h5>
            <div class="d-flex justify-content-between flex-wrap gap-4 me-12">
              <div class="d-flex align-items-center gap-4 me-6 me-sm-0">
                <div class="avatar avatar-lg">
                  <div class="avatar-initial bg-label-primary rounded">
                    <div>
                      <i class="ti ti-school ti-lg"></i>
                    </div>
                  </div>
                </div>
                <div class="content-right">
                  <p class="mb-0 fw-medium">Batches</p>
                  <h4 class="text-primary mb-0"><?php echo e($total_batches); ?></h4>
                </div>
              </div>
              <div class="d-flex align-items-center gap-4">
                <div class="avatar avatar-lg">
                  <div class="avatar-initial bg-label-info rounded">
                    <div>
                      <i class="ti ti-chalkboard ti-lg"></i>
                    </div>
                  </div>
                </div>
                <div class="content-right">
                  <p class="mb-0 fw-medium">Lessons</p>
                  <h4 class="text-info mb-0"><?php echo e($total_lessons); ?></h4>
                </div>
              </div>
              <?php if(Auth::user()->role_name != RoleTutor): ?>
              <div class="d-flex align-items-center gap-4">
                <div class="avatar avatar-lg">
                  <div class="avatar-initial bg-label-success rounded">
                    <div>
                      <i class="ti ti-user ti-lg"></i>
                    </div>
                  </div>
                </div>
                <div class="content-right">
                  <p class="mb-0 fw-medium">Tutors</p>
                  <h4 class="text-warning mb-0"><?php echo e($total_tutors); ?></h4>
                </div>
              </div>
              <div class="d-flex align-items-center gap-4">
                <div class="avatar avatar-lg">
                  <div class="avatar-initial bg-label-warning rounded">
                    <div>
                      <i class="ti ti-user ti-lg"></i>
                    </div>
                  </div>
                </div>
                <div class="content-right">
                  <p class="mb-0 fw-medium">Students</p>
                  <h4 class="text-warning mb-0"><?php echo e($total_students); ?></h4>
                </div>
              </div>
              <?php endif; ?>
            </div>
          </div>
          <div class="col-12 col-lg-4 ps-md-4 ps-lg-6">
            <div class="d-flex justify-content-between align-items-center">
              <div>
                <div>
                  <h5 class="mb-1">Lectures Time Spendings</h5>
                  <p class="mb-9">Weekly report</p>
                </div>
                <div class="time-spending-chart">
                  <h4 class="mb-2"> <?php echo e($lessons_time_spent[0]); ?><span class="text-body">h</span> <?php echo e($lessons_time_spent[1]); ?><span class="text-body">m</span></h4>
                </div>
              </div>
              <div id="leadsReportChart"></div>
            </div>
          </div>
      </div>
  </div>
  <div class="row g-6">
    <!-- Total Sales -->
    <div class="col-xxl-2 col-md-5 col-6">
      <div class="card h-100">
        <div class="card-body">
          <div class="badge p-2 bg-label-success mb-3 rounded">
            <i class="ti ti-credit-card ti-28px"></i>
          </div>
          <h5 class="card-title mb-1">Tutor Earnings</h5>
          <p class="card-subtitle"></p>
          <p class="text-heading mb-3 mt-1">&#x20B9; <?php echo e($tutor_earnings); ?> </p>
        </div>
      </div>
    </div>
    <div class="col-xxl-4 col-md-7">
      <div class="card h-100">
        <div class="card-body d-flex justify-content-between" style="position: relative;">
          <div class="d-flex flex-column">
            <div class="card-title mb-auto">
              <h5 class="mb-2 text-nowrap">Student Attendance</h5>
              <p class="mb-0">Weekly Report</p>
            </div>
          </div>
          <div id="revenueGrowth"></div>
          <div class="resize-triggers">
              <div class="expand-trigger">
                  <div style="width: 324px; height: 312px;"></div>
              </div>
              <div class="contract-trigger"></div>
          </div>
      </div>
    </div>
  </div>
  <div class="row g-6">
    <div class="col-md-6 mb-4">
      <div class="card h-100">
        <div class="card-header d-flex justify-content-between">
          <div class="card-title mb-0">
            <h5 class="mb-1">Lessons</h5>
            <p class="card-subtitle"></p>
          </div>
        </div>
        <div class="card-body row">
          <div class="col-12 col-sm-4 col-md-12 col-lg-4">
            <div class="mt-lg-4 mt-lg-2 mb-lg-6 mb-2">
              <h2 class="mb-0"><?php echo e($total_lessons); ?></h2>
              <p class="mb-0">Total Lessons</p>
            </div>
            <ul class="p-0 m-0">
              <li class="d-flex gap-4 align-items-center mb-lg-3 pb-1">
                <div class="badge rounded bg-label-primary p-1_5"><i class="ti ti-ticket ti-md"></i></div>
                <div>
                  <h6 class="mb-0 text-nowrap">Planned</h6>
                  <small class="text-muted"><?php echo e($planned_lessons->count()); ?></small>
                </div>
              </li>
              <li class="d-flex gap-4 align-items-center mb-lg-3 pb-1">
                <div class="badge rounded bg-label-info p-1_5">
                  <i class="ti ti-circle-check ti-md"></i>
                </div>
                <div>
                  <h6 class="mb-0 text-nowrap">In Progress</h6>
                  <small class="text-muted"><?php echo e($in_progress_lessons->count()); ?></small>
                </div>
              </li>
              <li class="d-flex gap-4 align-items-center pb-1">
                <div class="badge rounded bg-label-success p-1_5"><i class="ti ti-clock ti-md"></i></div>
                <div>
                  <h6 class="mb-0 text-nowrap">Completed</h6>
                  <small class="text-muted"><?php echo e($completed_lessons->count()); ?></small>
                </div>
              </li>
              <li class="d-flex gap-4 align-items-center pb-1">
                <div class="badge rounded bg-label-warning p-1_5"><i class="ti ti-clock ti-md"></i></div>
                <div>
                  <h6 class="mb-0 text-nowrap">Cancelled</h6>
                  <small class="text-muted"><?php echo e($cancelled_lessons->count()); ?></small>
                </div>
              </li>
            </ul>
          </div>
          <div class="col-12 col-sm-8 col-md-12 col-lg-8" style="position: relative;">
            <div id="supportTracker"></div>
            <div class="resize-triggers">
                <div class="expand-trigger">
                    <div style="width: 324px; height: 312px;"></div>
                </div>
                <div class="contract-trigger"></div>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <!-- Sales By Country -->
    <div class="col-md-6 mb-4">
      <div class="card h-100">
        <div class="card-header d-flex justify-content-between">
          <div class="card-title mb-0">
            <h5 class="mb-1">Tutor Batches</h5>
            <p class="card-subtitle"></p>
          </div>
        </div>
        <div class="card-body">
          <ul class="p-0 m-0">
            <?php
              $tutor_id = 0;
              if(Auth::user()->role_name == RoleTutor){
                $tutor = \App\Models\Tutors::where('user_id', Auth::user()->id)->first();
                $tutor_id = $tutor->id;
              }
            ?>
            <?php $__currentLoopData = $all_tutors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tutor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li class="d-flex align-items-center mb-4 
              <?php echo e((Auth::user()->role_name == RoleTutor && $tutor->id != $tutor_id) ? 'd-none': ''); ?>">
                <div class="avatar flex-shrink-0 me-4">
                  <span class="rounded-circle"><?php echo e($tutor->avatar_symbol); ?></span>
                </div>
                <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                  <div class="me-2">
                    <div class="d-flex align-items-center">
                      <h6 class="mb-0 me-1"><?php echo e($tutor->full_name); ?></h6>
                    </div>
                    <small class="text-body"></small>
                  </div>
                  <div class="user-progress">
                    <p class="mb-0 text-heading"><?php echo e($tutor->batches->count()); ?></p>
                  </div>
                </div>
              </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
        </div>
      </div>
    </div>
  </div>
  <div class="row">
    <div class="col-md-6 mb-4">
        <div class="card card-action mb-6">
            <div class="card-header align-items-center">
              <h5 class="card-action-title mb-0">
                <i class="ti ti-chart-bar ti-lg text-body me-4"></i>Activity Timeline
              </h5>
              <div class="dropdown">
                <button class="btn btn-text-secondary rounded-pill text-muted border-0 p-2 me-n1 waves-effect waves-light" type="button" id="popularProduct" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                  <i class="ti ti-dots-vertical ti-md text-muted"></i>
                </button>
                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="popularProduct" style="">
                  <a class="dropdown-item waves-effect" href="<?php echo e(route('activities.index')); ?>">Show All</a>
                </div>
              </div>
            </div>
            <div class="card-body pt-3">
              <ul class="timeline mb-0">
                <?php $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="timeline-item timeline-item-transparent">
                  <span class="timeline-point timeline-point-primary"></span>
                  <div class="timeline-event">
                    <?php 
                        $activity = get_activity_details($activity);
                    ?>
                    <div class="timeline-header mb-3">
                      <h6 class="mb-0"><?php echo e($activity['subject']); ?> is <?php echo e($activity['description']); ?></h6>
                      <small class="text-muted"><?php echo e(date(config('constant.date_format'), strtotime($activity['created_at']))); ?></small>
                    </div>
                    <p class="mb-2">
                        <a href="<?php echo e($activity['causer_url']); ?>"><?php echo e($activity['causer']); ?></a> <?php echo e($activity['description_lg']); ?> <a href="<?php echo e($activity['subject_url']); ?>"><?php echo e($activity['subject']); ?></a>
                    </p>
                  </div>
                </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
        </div>
        <div class="card card-action mb-6">
          <div class="card-header align-items-center">
              <h5 class="card-action-title mb-0">
                <i class="ti ti-device-tv ti-lg text-body me-4"></i>Live Lessons
              </h5>
          </div>
          <div class="card-body pt-3">
          <ul class="timeline mb-0">
                <?php $__currentLoopData = $in_progress_lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="timeline-item timeline-item-transparent">
                  <span class="timeline-point timeline-point-primary"></span>
                  <div class="timeline-event">
                    <div class="timeline-header mb-3">
                      <h6 class="mb-0"><?php echo e($lesson->batch->tutor->full_name); ?> is currently taking <a href="<?php echo e(route('lessons.view', $lesson->id)); ?>" target="_blank"><?php echo e($lesson->name); ?></a> of <br> <?php echo e($lesson->batch->name); ?> batch.</h6>
                      <small class="text-muted"><?php echo e(date(config('constant.date_format'), strtotime($lesson->start_date))); ?></small>
                    </div>
                  </div>
                </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
          </div>
        </div>
    </div>
    <div class="col-md-6 mb-4">
      <div class="card h-100">
        <div class="card-header d-flex justify-content-between">
          <div class="card-title m-0 me-2">
            <h5 class="mb-1">Upcoming Lessons</h5>
          </div>
          <div class="dropdown">
            <button class="btn btn-text-secondary rounded-pill text-muted border-0 p-2 me-n1 waves-effect waves-light" type="button" id="popularProduct" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              <i class="ti ti-dots-vertical ti-md text-muted"></i>
            </button>
            <div class="dropdown-menu dropdown-menu-end" aria-labelledby="popularProduct" style="">
              <a class="dropdown-item waves-effect" href="<?php echo e(route('tutors.lessons')); ?>">Show All</a>
            </div>
          </div>
        </div>
        <div class="card-body">
          <div class="bg-label-primary rounded text-center mb-4 pt-4">
            <img class="img-fluid" src="<?php echo e(asset('assets/img/illustrations/girl-with-laptop.png')); ?>" alt="Card girl image" width="140">
          </div>
          <?php $__currentLoopData = $lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <h5 class="mb-2"> 
              <a href="<?php echo e(route('lessons.view', $lesson->id)); ?>"><?php echo e($lesson->name); ?></a>
            </h5>
            <p class="small">
              <?php echo e($lesson->batch->name); ?>

            </p>
            <div class="row mb-4 g-3">
              <div class="col-12">
                <div class="d-flex">
                  <div class="avatar flex-shrink-0 me-3">
                    <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-user ti-28px"></i></span>
                  </div>
                  <div>
                    <h6 class="mb-0 text-nowrap"><?php echo e($lesson->batch->tutor->full_name); ?></h6>
                    <small>Tutor</small>
                  </div>
                </div>
              </div>
              <div class="col-12">
                <div class="d-flex">
                  <div class="avatar flex-shrink-0 me-3">
                    <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-calendar-event ti-28px"></i></span>
                  </div>
                  <div>
                    <h6 class="mb-0 text-nowrap"><?php echo e(date(config('constant.date_format_new'), strtotime($lesson->start_date))); ?></h6>
                    <small>Date</small>
                  </div>
                </div>
              </div>
              <div class="col-12">
                <div class="d-flex">
                  <div class="avatar flex-shrink-0 me-3">
                    <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-clock ti-28px"></i></span>
                  </div>
                  <div>
                    <h6 class="mb-0 text-nowrap"><?php echo e(date_diff_in_min($lesson->start_date, $lesson->end_date)); ?></h6>
                    <small>Duration</small>
                  </div>
                </div>
              </div>
            </div>
            <hr/>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>
    </div>
  </div>
  <?php endif; ?>
</div>
<style>
  .content-wrapper{
    margin-top: -100px;
  }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('after-scripts'); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('page-script'); ?>
  <?php if(Session::has('alert-message')): ?>
      <script>
          Toast.fire({
              type: "<?php echo e(Session::get('alert-class', 'info')); ?>",
              title: "<?php echo e(Session::get('alert-message')); ?>"
          });
      </script>
  <?php endif; ?>
  <style>
    .avatar .rounded-circle {
      height: 40px;
      width: 40px;
      display: block;
      text-align: center;
      padding-top: 6px;
      font-size: 20px;
      font-weight: bold;
      color: #fff;
      background: #ff9d34;
    }
  </style>
  <script>
    const completedLessons = <?php echo e(($total_lessons) ? round(($completed_lessons->count() * 100)/$total_lessons, 2) : 0); ?>;
    const weeklyAttendances = JSON.parse('<?php echo $weekly_attendances; ?>');
    const attendance_days = weeklyAttendances.map((d)=> {return d['date'];});
    const attendance_counts = weeklyAttendances.map((d)=> {return d['total'];});
    console.log(weeklyAttendances);
    const supportTrackerEl = document.querySelector('#supportTracker'),
    supportTrackerOptions = {
      series: [completedLessons],
      labels: ['Completed Lessons'],
      chart: {
        height: 360,
        type: 'radialBar'
      },
      plotOptions: {
        radialBar: {
          offsetY: 10,
          startAngle: -140,
          endAngle: 130,
          hollow: {
            size: '65%'
          },
          track: {
            background: config.colors.cardColor,
            strokeWidth: '100%'
          },
          dataLabels: {
            name: {
              offsetY: -20,
              color: config.colors.labelColor,
              fontSize: '13px',
              fontWeight: '400',
              fontFamily: 'Public Sans'
            },
            value: {
              offsetY: 10,
              color: config.colors.headingColor,
              fontSize: '38px',
              fontWeight: '400',
              fontFamily: 'Public Sans'
            }
          }
        }
      },
      colors: [config.colors.primary],
      fill: {
        type: 'gradient',
        gradient: {
          shade: 'dark',
          shadeIntensity: 0.5,
          gradientToColors: [config.colors.primary],
          inverseColors: true,
          opacityFrom: 1,
          opacityTo: 0.6,
          stops: [30, 70, 100]
        }
      },
      stroke: {
        dashArray: 10
      },
      grid: {
        padding: {
          top: -20,
          bottom: 5
        }
      },
      states: {
        hover: {
          filter: {
            type: 'none'
          }
        },
        active: {
          filter: {
            type: 'none'
          }
        }
      },
      responsive: [
        {
          breakpoint: 1025,
          options: {
            chart: {
              height: 330
            }
          }
        },
        {
          breakpoint: 769,
          options: {
            chart: {
              height: 280
            }
          }
        }
      ]
    };
    if (typeof supportTrackerEl !== undefined && supportTrackerEl !== null) {
      const supportTracker = new ApexCharts(supportTrackerEl, supportTrackerOptions);
      supportTracker.render();
    }

    const revenueGrowthEl = document.querySelector('#revenueGrowth'),
    revenueGrowthConfig = {
      chart: {
        height: 162,
        type: 'bar',
        parentHeightOffset: 0,
        toolbar: {
          show: false
        }
      },
      plotOptions: {
        bar: {
          barHeight: '80%',
          columnWidth: '30%',
          startingShape: 'rounded',
          endingShape: 'rounded',
          borderRadius: 7,
          distributed: true
        }
      },
      tooltip: {
        enabled: false
      },
      grid: {
        show: false,
        padding: {
          top: -20,
          bottom: -12,
          left: -10,
          right: 0
        }
      },
      colors: [
        config.colors_label.success,
        config.colors_label.success,
        config.colors_label.success,
        config.colors_label.success,
        config.colors.success,
        config.colors_label.success,
        config.colors_label.success
      ],
      dataLabels: {
        enabled: false
      },
      series: [
        {
          data: attendance_counts
        }
      ],
      legend: {
        show: false
      },
      xaxis: {
        categories: attendance_days,
        axisBorder: {
          show: false
        },
        axisTicks: {
          show: false
        },
        labels: {
          style: {
            colors: config.colors.labelColor,
            fontSize: '13px',
            fontFamily: 'Public Sans'
          }
        }
      },
      yaxis: {
        labels: {
          show: false
        }
      },
      states: {
        hover: {
          filter: {
            type: 'none'
          }
        }
      },
      responsive: [
        {
          breakpoint: 1471,
          options: {
            plotOptions: {
              bar: {
                columnWidth: '45%'
              }
            }
          }
        },
        {
          breakpoint: 1350,
          options: {
            plotOptions: {
              bar: {
                columnWidth: '57%'
              }
            }
          }
        },
        {
          breakpoint: 1032,
          options: {
            plotOptions: {
              bar: {
                columnWidth: '60%'
              }
            }
          }
        },
        {
          breakpoint: 992,
          options: {
            plotOptions: {
              bar: {
                columnWidth: '40%',
                borderRadius: 8
              }
            }
          }
        },
        {
          breakpoint: 855,
          options: {
            plotOptions: {
              bar: {
                columnWidth: '50%',
                borderRadius: 6
              }
            }
          }
        },
        {
          breakpoint: 440,
          options: {
            plotOptions: {
              bar: {
                columnWidth: '40%'
              }
            }
          }
        },
        {
          breakpoint: 381,
          options: {
            plotOptions: {
              bar: {
                columnWidth: '45%'
              }
            }
          }
        }
      ]
    };
  if(weeklyAttendances.length == 0){
    revenueGrowthEl.display = 'none';
  }
  else{
    revenueGrowthEl.display = 'block';
    if (typeof revenueGrowthEl !== undefined && revenueGrowthEl !== null) {
      const revenueGrowth = new ApexCharts(revenueGrowthEl, revenueGrowthConfig);
      revenueGrowth.render();
    }
  }

  
  // Donut Chart Colors
  const chartColors = {
    donut: {
      series1: '#209F59',
      series2: '#24B364',
      series3: config.colors.success,
      series4: '#53D28C',
      series5: '#7EDDA9',
      series6: '#A9E9C5'
    }
  };

  const leadsReportChartEl = document.querySelector('#leadsReportChart'),
    leadsReportChartConfig = {
      chart: {
        height: 170,
        width: 150,
        parentHeightOffset: 0,
        type: 'donut'
      },
      labels: ['<?php echo $lessons_time_spent[0]; ?>'],
      series: ['<?php echo $lessons_time_spent[1]; ?>'],
      colors: [
        chartColors.donut.series1,
        chartColors.donut.series2,
        chartColors.donut.series3,
        chartColors.donut.series4,
        chartColors.donut.series5,
        chartColors.donut.series6
      ],
      stroke: {
        width: 0
      },
      dataLabels: {
        enabled: false,
        formatter: function (val, opt) {
          return parseInt(val) + '%';
        }
      },
      legend: {
        show: false
      },
      tooltip: {
        theme: false
      },
      grid: {
        padding: {
          top: 0
        }
      },
      plotOptions: {
        pie: {
          donut: {
            size: '70%',
            labels: {
              show: true,
              value: {
                fontSize: '1.125rem',
                fontFamily: 'Public Sans',
                color: config.colors.headingColor,
                fontWeight: 500,
                offsetY: -20,
                formatter: function (val) {
                  return parseInt(val) + '%';
                }
              },
              name: {
                offsetY: 20,
                fontFamily: 'Public Sans'
              },
              total: {
                show: true,
                fontSize: '.9375rem',
                label: 'Total ',
                color: config.colors.labelColor,
                formatter: function (w) {
                  return '<?php echo $lessons_time_spent[0]; ?>h <?php echo $lessons_time_spent[1]; ?>m';
                }
              }
            }
          }
        }
      }
    };
  if (typeof leadsReportChartEl !== undefined && leadsReportChartEl !== null) {
    const leadsReportChart = new ApexCharts(leadsReportChartEl, leadsReportChartConfig);
    leadsReportChart.render();
  }
  </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/thereadernest/public_html/resources/views/home.blade.php ENDPATH**/ ?>