<?php if(isset($page_title) && $page_title!=''): ?>
    <?php $__env->startSection('title', $page_title.' - '.config('app.name')); ?>
<?php else: ?>
    <?php $__env->startSection('title', config('app.name')); ?>
<?php endif; ?>
<?php $__env->startSection('content'); ?>
<div class="card">
  <div class="card-header border-bottom">
    <div class="row">
      <div class="col-md-6">
        <h5 class="card-title mb-0">Students</h5>
      </div>
      <div class="col-md-6">
          <div class="dt-action-buttons text-xl-end text-lg-start text-md-end text-start d-flex align-items-center justify-content-end flex-md-row flex-column mb-6 mb-md-0 mt-n6 mt-md-0">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['create-student'])): ?>
                <div class="dt-buttons btn-group flex-wrap">
                  <a href="<?php echo e(route('students.add')); ?>" class="btn btn-secondary add-new btn-primary waves-effect waves-light" 
                  tabindex="0" type="button" ><span><i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block">Add Student</span></span></a> 
                </div>
                <?php endif; ?>
          </div>
      </div>
    </div>
  </div>
  <div class="card-body table-responsive pt-4">
    <table id="DataTable1" class="datatables-roles table">
      <thead class="border-top">
        <tr>
          <th></th>
          <th>Name</th>
          <th>Gender</th>
          <th>Batches</th>
          <th>Created At</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
      </tbody>
    </table>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
<?php if(Session::has('alert-message')): ?>
<script>
    Toast.fire({
        type: "<?php echo e(Session::get('alert-class', 'info')); ?>",
        title: "<?php echo e(Session::get('alert-message')); ?>"
    });
</script>
<?php endif; ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/libs/datatables/jquery.dataTables.min.css')); ?>"></script>
<link rel="stylesheet" href="<?php echo e(asset('assets/libs/datatables/responsive.dataTables.min.css')); ?>"></script>
<link rel="stylesheet" href="<?php echo e(asset('assets/libs/datatables/jquery.dataTable.orderride.css')); ?>"></script>
<script src="<?php echo e(asset('assets/libs/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/libs/datatables/dataTables.bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/libs/datatables/dataTables.responsive.min.js')); ?>"></script>
<script type="text/javascript">
    var table;
    $(document).ready(function() {
	    table=$('#DataTable1').DataTable({
	    	responsive: true,
	        processing: true,
	        serverSide: true,
	        searching: true,
	        ajax:{
	            headers: {'X-CSRF-Token': Laravel.csrfToken},
	            url:'<?php echo route("students"); ?>',
	            type:'GET'
	        },
	        columns: [
	            {data: 'id', name: 'id'},
	            {data: 'name', name: 'name'},
	            {data: 'gender', name: 'gender'},
	            {data: 'batches', name: 'batches'},
	            {data: 'created_at', name: 'created_at'},
	            {data: 'action', name: 'action', sortable:false}
	        ],
	        order: [[0, 'desc']]
	    });
    });
    
    function deleteRecord(ele,id){
      Swal.fire({
          title: 'Are you sure?',
          text: "You won't be able to revert this!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonText: 'Yes, delete it!',
          confirmButtonColor: "#d33",
          confirmButtonClass: 'btn btn-success',
          cancelButtonText: 'No, cancel!',
          cancelButtonColor: '#3085d6',
          cancelButtonClass: 'btn btn-danger',
          buttonsStyling: true,
          reverseButtons: true
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  type: "POST",
                  headers: {'X-CSRF-Token': Laravel.csrfToken},
                  url: '<?php echo route("students.destroy"); ?>',
                  dataType : 'json',
                  data: {id:id},
                  success: function(response) {
                      setTimeout( function () {
                          redrawDatatable();
                      }, 1000 );
                      if(response.success == true){
                        Swal.fire({
                            type : 'success',
                            title: 'Deleted!',
                            text : response.message,
                            timer: '1500'
                        });
                      }else{
                        Swal.fire({
                            type : 'error',
                            title: 'Not Deleted!',
                            text : response.message,
                            timer: '1500'
                        });
                      }
                  },
                  error: function (jqXHR, status, exception) {
                      if (jqXHR.status === 0) {
                          error = 'Not connected.\nPlease verify your network connection.';
                      } else if (jqXHR.status == 404) {
                          error = 'The requested page not found. [404]';
                      } else if (jqXHR.status == 500) {
                          error = 'Internal Server Error [500].';
                      } else if (exception === 'parsererror') {
                          error = 'Requested JSON parse failed.';
                      } else if (exception === 'timeout') {
                          error = 'Time out error.';
                      } else if (exception === 'abort') {
                          error = 'Ajax request aborted.';
                      } else {
                          error = 'Uncaught Error.\n' + jqXHR.responseText;
                      }
                      Swal.fire('Error!',error,'error');
                  }
              });
          }
      });
    }
    function redrawDatatable(){
        $('#DataTable1').DataTable().ajax.reload();
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u384437918/domains/dev.thereadernest.in/public_html/resources/views/students/index.blade.php ENDPATH**/ ?>