<?php if(isset($page_title) && $page_title!=''): ?>
    <?php $__env->startSection('title', $page_title.' - '.config('app.name')); ?>
<?php else: ?>
    <?php $__env->startSection('title', config('app.name')); ?>
<?php endif; ?>
<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0"><?php echo e($header); ?></h5>
    </div>
    <div class="card-body pt-4">
        <form action="<?php echo e(route('batches.student.store')); ?>"  class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST" novalidate="novalidate">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="id" id="id" value="<?php echo e(isset($batch->id) ? $batch->id : ''); ?>">
            
            <div class="col-6 fv-plugins-icon-container">
            <div class="accordion stick-top accordion-custom-button course-content-fixed" id="courseContent">
                <div class="accordion-item mb-0 active">
                    <div class="accordion-header" id="headingOne">
                    <button type="button" class="accordion-button" data-bs-toggle="collapse" data-bs-target="#chapterOne" aria-expanded="true" aria-controls="chapterOne">
                        <span class="d-flex flex-column">
                        <span class="h5 mb-0">Students</span>
                        </span>
                    </button>
                    </div>
                    <div id="chapterOne" class="accordion-collapse collapse show" data-bs-parent="#courseContent" style="">
                    <div class="accordion-body py-4">
                        <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="form-check d-flex align-items-center gap-1 mb-4">
                            <input class="form-check-input" name="students[]" value="<?php echo e($student->id); ?>" type="checkbox" id="student_<?php echo e($student->id); ?>">
                            <label for="defaultCheck1" class="form-check-label ms-4">
                            <span class="mb-0 h6"><?php echo e($student->first_name.' '.$student->last_name); ?></span>
                            </label>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    </div>
                </div>
                </div>
            </div>
            <div class="col-12 text-center">
                <button type="submit" class="btn btn-primary me-3 waves-effect waves-light">Submit</button>
                <a href="<?php echo e(route('batches')); ?>" class="btn btn-label-secondary waves-effect">Cancel</a>
            </div>
        </form>
    </div>
</div>
<br/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
<?php if(Session::has('alert-message')): ?>
<script>
    Toast.fire({
        type: "<?php echo e(Session::get('alert-class', 'info')); ?>",
        title: "<?php echo e(Session::get('alert-message')); ?>"
    });
</script>
<?php endif; ?>
<script type="text/javascript">
    $(document).ready(function() {
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u384437918/domains/thereadernest.in/public_html/resources/views/batches/add_student.blade.php ENDPATH**/ ?>