
<?php if(isset($page_title) && $page_title!=''): ?>
    <?php $__env->startSection('title', $page_title.' - '.config('app.name')); ?>
<?php else: ?>
    <?php $__env->startSection('title', config('app.name')); ?>
<?php endif; ?>
<?php $__env->startSection('page-style'); ?>
<style type="text/css">
	.th-width{
		width: 25% !important;
	}
	h4.text-custom{
        font-weight: 500;
        color: #2cabe3;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex flex-column flex-sm-row align-items-center justify-content-sm-between mb-6 text-center text-sm-start gap-2">
  <div class="mb-2 mb-sm-0">
    <h4 class="mb-1">Ticket Number #<?php echo e(old( 'number', isset($ticket->number) ? $ticket->number : '')); ?></h4>
    <p class="mb-0"><?php echo e((isset($ticket->created_at) ? date(config('constant.date_format_new'),strtotime($ticket->created_at)) :'-')); ?></p>
  </div>
</div>
<div class="row">
  <!-- Customer-detail Sidebar -->
  <div class="col-xl-5 col-lg-6 col-md-6 order-1 order-md-0">
    <!-- Customer-detail Card -->
    <div class="card mb-6">
      <div class="card-body pt-2">
        <div class="info-container">
          <h5 class="pb-4 border-bottom text-capitalize mt-6 mb-4">Details</h5>
          <ul class="list-unstyled mb-6">
            <li class="mb-2">
              <span class="h6 me-1">Title:</span>
              <span><?php echo e(old( 'title', isset($ticket->title) ? $ticket->title : '')); ?></span>
            </li>
            <li class="mb-2">
              <span class="h6 me-1">Priority:</span>
              <span><?php echo e($priority); ?></span>
            </li>
            <li class="mb-2">
              <span class="h6 me-1">Status:</span>
              <span><?php echo e($status); ?></span>
            </li>
            <?php if($ticket->attachment): ?>
            <li class="mb-2">
              <span class="h6 me-1">Attachment:</span>
              <span>
                <a download="" href="<?php echo e(asset(config('constant.ticket_attach').$ticket->attachment)); ?>"><?php echo e($ticket->attachment); ?></a>
              </span>
            </li>
            <?php endif; ?>
            <li class="mb-2">
              <span class="h6 me-1">Created By:</span>
              <span><?php echo e((isset($ticket->_created_by) ? $ticket->_created_by->name :'-')); ?></span>
            </li>
            <li class="mb-2">
              <span class="h6 me-1">Created At:</span>
              <span><?php echo e((isset($ticket->created_at) ? date(config('constant.date_format_new'),strtotime($ticket->created_at)) :'-')); ?></span>
            </li>
            <li class="mb-2">
              <span class="h6 me-1">Assigned To:</span>
              <span><?php echo e((isset($ticket->_assigned_to) ? $ticket->_assigned_to->name :'-')); ?></span>
            </li>
            <li class="mb-2">
              <span class="h6 me-1">Assigned At:</span>
              <span><?php echo e((isset($ticket->assigned_at) ? date(config('constant.date_format_new'),strtotime($ticket->assigned_at)) :'-')); ?></span>
            </li>
          </ul>
        </div>
      </div>
    </div>
    <?php if(Auth::user()->role_name == RoleAdmin || Auth::user()->role_name == RoleSuperAdmin): ?>
    <div class="card mb-6">
      <div class="card-body pt-2">
        <form action="<?php echo e(route('tickets.statusUpdate')); ?>" name="assignform" id="assignform" method="POST">
          <?php echo csrf_field(); ?>
          <input type="hidden" name="ticket_id" value="<?php echo e($ticket->id); ?>">
          <div class="form-body">
            <div class="row">
              <div class="col-md-12">
                <div class="form-group <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                  <label class="control-label">Status</label>		
                  <select class="form-control" name="status" id="status">
                    <option value="">Please select status</option>

                    <?php if($ticket->status == TicketStatusCreated): ?>
                    <option value="1">Assigned</option>
                    <option value="2">Closed</option>
                    <?php elseif($ticket->status == TicketStatusAssigned || $ticket->status == TicketStatusReopen): ?>
                    <option value="2">Closed</option>
                    <?php endif; ?>
                    
                    <?php if($ticket->status == TicketStatusClosed): ?>
                      <option value="3">Reopen</option>
                    <?php endif; ?>
                  </select>
                  <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="invalid-feedback" role="alert">
                      <?php echo e($message); ?>

                    </span>
                  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
              </div>
            </div>
            <div class="form-actions mt-2">
              <button type="submit" class="btn btn-success"> <i class="fa fa-check"></i> Save</button>
              <a href="<?php echo e(route('tickets.view', $ticket->id)); ?>" class="btn btn-default">Cancel</a>
            </div>
          </div>
        </form>
      </div>
    </div>
    <div class="card mb-6">
      <div class="card-body pt-2">
        <form action="<?php echo e(route('tickets.assign')); ?>" name="assignform" id="assignform" method="POST">
          <?php echo csrf_field(); ?>
          <input type="hidden" name="ticket_id" value="<?php echo e($ticket->id); ?>">
          <div class="form-body">
            <div class="row">
              <div class="col-md-12">
                <div class="form-group <?php $__errorArgs = ['assigned_to'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                  <label class="control-label">Assigned To</label>
                  <select class="form-control" name="assigned_to" id="assigned_to">
                    <option value="">Please select user</option>
                    <?php if(isset($users) && count($users)>0): ?>
                      <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php 
                          $roles = [];
                          foreach($value->roles as $role)
                            array_push($roles, $role->display_name);
                          
                        ?>
                        <option value="<?php echo e($value->id); ?>"><?php echo e($value->name); ?> (<?php echo e(implode(',', $roles)); ?>) (<?php echo e($value->email); ?>)</option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                  </select>
                  <?php $__errorArgs = ['assigned_to'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="invalid-feedback" role="alert">
                      <?php echo e($message); ?>

                    </span>
                  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
              </div>
            </div>
            <div class="form-actions mt-2">
              <button type="submit" class="btn btn-success"> <i class="fa fa-check"></i> Save</button>
              <a href="<?php echo e(route('tickets.view', $ticket->id)); ?>" class="btn btn-default">Cancel</a>
            </div>
          </div>
        </form>
      </div>
    </div>
    <?php endif; ?>
  </div>
  <div class="col-xl-7 col-lg-6 col-md-6 order-0 order-md-1">
    <h5>Comments</h5>
    <div class="row text-nowrap">
      <?php $__currentLoopData = $ticket->comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="col-md-12 mb-5">
        <div class="card h-100">
          <div class="card-body">
            <div class="card-info">
              <h5 class="card-title mb-2"><?php echo e($value->_created_by ? $value->_created_by->name : ''); ?></h5>
              <div class="d-flex align-items-baseline gap-1">
                <p class="mb-0"><?php echo (isset($value->comments) ? $value->comments :'-'); ?></p>
              </div>
              <p class="mb-0" style="text-align: right;font-size: 12px;padding-top: 10px;"><?php echo e(date(config('constant.date_format_new'),strtotime($value->created_at))); ?></p>
            </div>
          </div>
        </div>
      </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <?php if($ticket->status != TicketStatusClosed): ?>
    <div class="row text-nowrap">
      <div class="col-md-12 mb-12">
        <div class="card h-100">
          <div class="card-body">
            <form action="<?php echo e(route('tickets.comment')); ?>" name="commentform" id="commentform" method="POST" >
              <?php echo csrf_field(); ?>
              <input type="hidden" name="ticket_id" value="<?php echo e($ticket->id); ?>">
              <div class="form-body">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group <?php $__errorArgs = ['comments'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                      <label class="control-label">Comment</label>
                      <textarea class="form-control" name="comments" id="note"><?php echo e(old('comments')); ?></textarea>
                      <?php $__errorArgs = ['comments'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="invalid-feedback" role="alert">
                          <?php echo e($message); ?>

                        </span>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                  </div>
                </div>
                <div class="form-actions mt-2">
                  <button type="submit" class="btn btn-success"> <i class="fa fa-check"></i> Save</button>
                  <a href="<?php echo e(route('tickets')); ?>" class="btn btn-default">Cancel</a>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
    <?php endif; ?>
  </div>
</div>
<br/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
<?php if(Session::has('alert-message')): ?>
<script>
    Toast.fire({
        type: "<?php echo e(Session::get('alert-class', 'info')); ?>",
        title: "<?php echo e(Session::get('alert-message')); ?>"
    });
</script>
<?php endif; ?>
<script type="text/javascript">
    var table;
    $(document).ready(function() {
      $('#chkHideCompletedLesson').change(function(){
        if($(this).is(":checked")) {
          $('.lesson.completed').hide();
        }
        else{
          $('.lesson').show();
        }
      });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/thereadernest/public_html/resources/views/tickets/view.blade.php ENDPATH**/ ?>