<?php if(isset($page_title) && $page_title!=''): ?>
    <?php $__env->startSection('title', $page_title.' - '.config('app.name')); ?>
<?php else: ?>
    <?php $__env->startSection('title', config('app.name')); ?>
<?php endif; ?>
<?php $__env->startSection('page-style'); ?>
<style type="text/css">
	.th-width{
		width: 25% !important;
	}
	h4.text-custom{
        font-weight: 500;
        color: #2cabe3;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="row mb-10">
  <div class="col-md-4">
    <div class="card h-100">
      <div class="card-header border-bottom">
        <h5 class="card-title mb-0">View Batch</h5>
      </div>
      <div class="card-body pt-4">
        <ul class="list-unstyled my-3 py-1">
          <li class="d-flex align-items-center mb-4">
            <span class="fw-medium mx-2">Name:</span>
            <span><?php echo e(old( 'name', isset($batch->name) ? $batch->name : '')); ?></span>
          </li>
          <li class="d-flex align-items-center mb-4">
            <span class="fw-medium mx-2">Description:</span>
            <div><?php echo e(old( 'description', isset($batch->description) ? $batch->description : '')); ?></div>
          </li>
          <li class="d-flex align-items-center mb-4">
            <span class="fw-medium mx-2">Tutor:</span>
            <span>
              <?php if(Auth::user()->role_name != RoleStudent): ?>
              <a href="<?php echo e(route('tutors.view', $batch->tutor->id)); ?>">
                <?php echo e(old( 'email', isset($batch->tutor) ? $batch->tutor->full_name : '')); ?>

              </a>
              <?php else: ?>
                <div><?php echo e(old( 'email', isset($batch->tutor) ? $batch->tutor->full_name : '')); ?></div>
              <?php endif; ?>
            </span>
          </li>
        </ul>
        <div class="row">
          <div class="col-md-12">
            <?php if(Auth::user()->role_name == RoleAdmin || Auth::user()->role_name == RoleSuperAdmin): ?>
              <div class="dt-action-buttons text-xl-end text-lg-start text-md-end text-start d-flex align-items-center justify-content-end flex-md-row flex-column mb-6 mb-md-0 mt-n6 mt-md-0">
                  <div class="dt-buttons btn-group flex-wrap">
                    <form action="<?php echo e(route('batches.reminder')); ?>" class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST">
                      <?php echo csrf_field(); ?>
                      <input type="hidden" name="id" id="id" value="<?php echo e($batch->id); ?>">
                      <button type="submit" class="btn btn-secondary add-new btn-primary waves-effect waves-light" 
                      tabindex="0" ><span><i class="ti ti-currency-rupee me-0 me-sm-1 ti-xs"></i>
                        <span class="d-none d-sm-inline-block">Send Fee Reminder</span></span></a> 
                    </form>  
                  </div>
              </div>
              <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-md-8">
    <div class="card h-100">
      <div class="card-header d-flex flex-wrap justify-content-between">
        <h4>Students (<?php echo e($batch->students->count()); ?>)</h4>
      </div>
      <div class="card-body" style="height: 350px;overflow: hidden;overflow-y: auto;">
        <div class="row">
          <?php $__currentLoopData = $batch->students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="col-xl-4 col-lg-5 col-md-4 order-1 order-md-0">
            <!-- Customer-detail Card -->
            <div class="card mb-6">
              <div class="card-body pt-12">
                <div class="customer-avatar-section">
                  <div class="d-flex align-items-center flex-column">
                    <img class="img-fluid rounded mb-4" src="<?php echo e(asset('assets/img/avatars/user.png')); ?>" height="120" width="120" alt="User avatar">
                    <div class="customer-info text-center">
                      <h5 class="mb-0"><?php echo e($student->full_name); ?></h5>
                      <p><?php echo e($student->gender); ?></p>
                    </div>
                  </div>
                </div>
    
                <?php if(Auth::user()->role_name == RoleAdmin || Auth::user()->role_name == RoleSuperAdmin): ?>
                <div class="info-container">
                  <h5 class="pb-4 border-bottom text-capitalize mt-6 mb-4">Details</h5>
                  <ul class="list-unstyled mb-2">
                    <li class="mb-2">
                      <span class="h6 me-1">Parent Name:</span>
                      <span><?php echo e($student->parent_name); ?></span>
                    </li>
                    <li class="mb-2">
                      <span class="h6 me-1">Parent Email:</span>
                      <span><?php echo e($student->parent_email); ?></span>
                    </li>
                    <li class="mb-2">
                      <span class="h6 me-1">Parent Mobile:</span>
                      <span><?php echo e($student->parent_mobile); ?></span>
                    </li>
                  </ul>
                </div>
                <?php endif; ?>
              </div>
            </div>
            <!-- /Customer-detail Card -->
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>
    </div>
  </div>
</div>
<br/>
<div class="card mb-6">
  <div class="card-header">
    <div class="card-title mb-0 me-1">
      <h5 class="mb-0">Lessons</h5>
      <p class="mb-0">Total <?php echo e($batch->lessons->count()); ?> lessons are in <?php echo e($batch->name); ?> batch. </p>
      <br/>
      <ul class="list-unstyled my-3 py-1">
          <li class="d-flex align-items-center mb-4">
            <span class="fw-medium mx-2">Filter Lessons:</span>
            <span>
              <select id="sl-filter-lessons" class="form-select w-25" style="min-width: 200px;">
                <option value=""></option>
                <option value="<?php echo e(LessonStatusPlanned); ?>">Planned</option>
                <option value="<?php echo e(LessonStatusInProgress); ?>">In Progress</option>
                <option value="<?php echo e(LessonStatusCompleted); ?>">Completed</option>
                <option value="<?php echo e(LessonStatusCancelled); ?>">Cancelled</option>
                <option value="<?php echo e(LessonStatusReportGenerated); ?>">Report Generated</option>
              </select>
            </span>
          </li>
        </ul>
    </div>
  </div>
  <div class="card-body">
    <div class="row gy-6 mb-6">
      <?php $__currentLoopData = $batch->lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
          $lesson_status = 'lesson-'.$lesson->status;
          $status = get_lesson_status($lesson->status);
        ?>
        <div class="col-sm-6 col-lg-4 lesson <?php echo e($lesson_status); ?>">
          <div class="card p-2 h-100 shadow-none border">
            <div class="card-body p-4 pt-2">
              <div class="d-flex justify-content-between align-items-center mb-4">
              </div>
              <a href="<?php echo e(route('lessons.view', $lesson->id)); ?>" class="h4 mb-2"><?php echo e($lesson->name); ?></a>
              <p><?php echo e($batch->name); ?></p>
              <div class="row mb-4 g-3">
                <div class="col-12">
                  <div class="d-flex">
                    <div class="avatar flex-shrink-0 me-3">
                      <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-user ti-28px"></i></span>
                    </div>
                    <div>
                      <h6 class="mb-0 text-nowrap"><?php echo e($lesson->batch->tutor->full_name); ?></h6>
                      <small>Tutor</small>
                    </div>
                  </div>
                </div>
                <div class="col-12">
                  <div class="d-flex">
                    <div class="avatar flex-shrink-0 me-3">
                      <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-calendar-event ti-28px"></i></span>
                    </div>
                    <div>
                      <h6 class="mb-0 text-nowrap"><?php echo e(date(config('constant.date_format_new'), strtotime($lesson->start_date))); ?></h6>
                      <small>Date</small>
                    </div>
                  </div>
                </div>
                <div class="col-12">
                  <div class="d-flex">
                    <div class="avatar flex-shrink-0 me-3">
                      <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-clock ti-28px"></i></span>
                    </div>
                    <div>
                      <h6 class="mb-0 text-nowrap"><?php echo e(date_diff_in_min($lesson->start_date, $lesson->end_date)); ?></h6>
                      <small>Duration</small>
                    </div>
                  </div>
                </div>
                <div class="col-12">
                  <div class="d-flex">
                    <div class="avatar flex-shrink-0 me-3">
                      <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-progress ti-28px"></i></span>
                    </div>
                    <div>
                      <h6 class="mb-0 text-nowrap text-<?php echo e($status ['type']); ?>"><?php echo e($status['status']); ?></h6>
                      <small>Status</small>
                    </div>
                  </div>
                </div>
              </div>
              <?php if(Auth::user()->role_name == RoleAdmin || Auth::user()->role_name == RoleSuperAdmin): ?>
                <div class="d-flex flex-column flex-md-row gap-4">
                  <a class="btn btn-primary"  href="<?php echo e(route('lessons.view', $lesson->id)); ?>">
                    <span>Open <?php echo e($lesson->name); ?></span>
                  </a>
                  <?php if(!in_array($lesson->status, [LessonStatusInProgress, LessonStatusCompleted, LessonStatusReportGenerated])): ?>
                    <a class="w-10 btn btn-secondary" href="<?php echo e(route('batches.lesson.timings', $lesson->id)); ?>">
                      <i class="fa fa-pencil"></i>
                    </a>
                    <a class="w-10 btn btn-secondary" href="javscript:void(0);" onclick="deleteRecord(<?php echo e($lesson->id); ?>)">
                      <i class="fa fa-trash"></i>
                    </a> 
                  <?php endif; ?>
                </div>
              <?php else: ?>
                <div class="d-flex flex-column flex-md-row gap-4">
                  <a class="btn btn-primary"  href="<?php echo e(route('lessons.view', $lesson->id)); ?>">
                    <span>Open <?php echo e($lesson->name); ?></span>
                  </a>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
  </div>
</div>
<style>
  .lesson {
    display: none;
  }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
<?php if(Session::has('alert-message')): ?>
<script>
    Toast.fire({
        type: "<?php echo e(Session::get('alert-class', 'info')); ?>",
        title: "<?php echo e(Session::get('alert-message')); ?>"
    });
</script>
<?php endif; ?>
<script type="text/javascript">
    $(document).ready(function() {
      $('.lesson.lesson-'+<?php echo e(LessonStatusInProgress); ?>).show();
      $('#sl-filter-lessons').change(function(){
        status = $(this).val();
        $('.lesson').hide();
        $('.lesson.lesson-'+status).show();
      });
    });
    
    function deleteRecord(id){
      Swal.fire({
          title: 'Are you sure?',
          text: "You won't be able to revert this!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonText: 'Yes, delete it!',
          confirmButtonColor: "#d33",
          confirmButtonClass: 'btn btn-success',
          cancelButtonText: 'No, cancel!',
          cancelButtonColor: '#3085d6',
          cancelButtonClass: 'btn btn-danger',
          buttonsStyling: true,
          reverseButtons: true
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  type: "POST",
                  headers: {'X-CSRF-Token': Laravel.csrfToken},
                  url: '<?php echo route("lessons.destroy"); ?>',
                  dataType : 'json',
                  data: {id:id},
                  success: function(response) {
                      setTimeout( function () {
                          redrawDatatable();
                      }, 1000 );
                      if(response.success == true){
                        Swal.fire({
                            type : 'success',
                            title: 'Deleted!',
                            text : response.message,
                            timer: '1500'
                        });
                        location.reload();
                      }else{
                        Swal.fire({
                            type : 'error',
                            title: 'Not Deleted!',
                            text : response.message,
                            timer: '1500'
                        });
                      }
                  },
                  error: function (jqXHR, status, exception) {
                      if (jqXHR.status === 0) {
                          error = 'Not connected.\nPlease verify your network connection.';
                      } else if (jqXHR.status == 404) {
                          error = 'The requested page not found. [404]';
                      } else if (jqXHR.status == 500) {
                          error = 'Internal Server Error [500].';
                      } else if (exception === 'parsererror') {
                          error = 'Requested JSON parse failed.';
                      } else if (exception === 'timeout') {
                          error = 'Time out error.';
                      } else if (exception === 'abort') {
                          error = 'Ajax request aborted.';
                      } else {
                          error = 'Uncaught Error.\n' + jqXHR.responseText;
                      }
                      Swal.fire('Error!',error,'error');
                  }
              });
          }
      });
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u384437918/domains/dev.thereadernest.in/public_html/resources/views/batches/view.blade.php ENDPATH**/ ?>