
<?php if(isset($page_title) && $page_title!=''): ?>
    <?php $__env->startSection('title', $page_title.' - '.config('app.name')); ?>
<?php else: ?>
    <?php $__env->startSection('title', config('app.name')); ?>
<?php endif; ?>
<?php $__env->startSection('page-style'); ?>
<style type="text/css">
	.th-width{
		width: 25% !important;
	}
	h4.text-custom{
        font-weight: 500;
        color: #2cabe3;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="row">
  <div class="col-md-6 mb-4">
    <div class="card">
      <div class="card-header border-bottom">
        <h5 class="card-title mb-0">View Report</h5>
      </div>
      <div class="card-body pt-4">
          <ul class="list-unstyled my-3 py-1">
            <li class="d-flex align-items-center mb-4">
              <?php
                $status = get_lesson_status($lesson->status);
              ?>
              <div class="mb-4 d-flex flex-column flex-md-row gap-4 text-nowrap flex-wrap flex-md-nowrap flex-lg-wrap flex-xxl-nowrap">
                <a class="w-100 btn btn-label-<?php echo e($status ['type']); ?> <?php echo e($status ['type']); ?>-effect" href="javascript:void(0)">
                  <span><?php echo e($status['status']); ?></span>
                </a>
              </div>
            </li>
            <li class="d-flex align-items-center mb-4">
              <span class="fw-medium mx-2">Batch Name:</span>
              <span><?php echo e(old( 'name', isset($lesson->batch) ? $lesson->batch->name : '')); ?></span>
            </li>
            <li class="d-flex align-items-center mb-4">
              <span class="fw-medium mx-2">Lesson Name:</span>
              <span><?php echo e(old( 'name', isset($lesson->name) ? $lesson->name : '')); ?></span>
            </li>
            <li class="d-flex align-items-center mb-4">
              <span class="fw-medium mx-2">Tutor:</span>
              <span><?php echo e(old( 'name', isset($lesson->batch) ? $lesson->batch->tutor->full_name : '')); ?></span>
            </li>
            <li class="d-flex align-items-center mb-4">
              <span class="fw-medium mx-2">Comments:</span>
              <span><?php echo e(old( 'name', isset($lesson->comments) ? $lesson->comments : '')); ?></span>
            </li>
            <li class="d-flex align-items-center mb-4">
              <span class="fw-medium mx-2">Started At:</span>
              <span><?php echo e(($lesson->start_date!=null)?date(config('constant.date_format_new'), strtotime($lesson->start_date)):'-'); ?></span>
            </li>
            <li class="d-flex align-items-center mb-4">
              <span class="fw-medium mx-2">Completed At:</span>
              <span><?php echo e(($lesson->end_date!=null)?date(config('constant.date_format_new'), strtotime($lesson->end_date)):'-'); ?></span>
            </li>
            <li class="d-flex align-items-center mb-4">
              <span class="fw-medium mx-2">Report Generated On:</span>
              <span><?php echo e(($lesson->report_generated_at!=null)?date(config('constant.date_format_new'), strtotime($lesson->report_generated_at)):'-'); ?></span>
            </li>
          </ul>
      </div>
  </div>
  </div>
  <div class="col-md-6 mb-4">
    <div class="card h-100">
      <div class="card-header d-flex align-items-center justify-content-between">
        <div class="card-title mb-0">
          <h5 class="m-0 me-2">Students</h5>
        </div>
      </div>
      <div class="px-5 py-4 border border-start-0 border-end-0">
        <div class="d-flex justify-content-between align-items-center">
          <p class="mb-0 text-uppercase">Name</p>
          <p class="mb-0 text-uppercase">Attendence</p>
        </div>
      </div>
      <div class="card-body">
        <?php $__currentLoopData = $lesson->batch->students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="d-flex justify-content-between align-items-center mb-6">
          <div class="d-flex align-items-center">
            <div class="avatar avatar me-4">
              <span class="rounded-circle"><?php echo e($student->avatar_symbol); ?></span>
            </div>
            <div>
              <div>
                <h6 class="mb-0 text-truncate"><?php echo e($student->full_name); ?></h6>
                <small class="text-truncate text-body"><?php echo e(strtoupper($student->gender)); ?></small>
              </div>
            </div>
          </div>
          <div class="text-end">
            <?php if(Auth::user()->role_name == RoleTutor): ?>
              <form action="<?php echo e(route('lessons.attendance')); ?>"  class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="lesson_id" value="<?php echo e($lesson->id); ?>">
                <input type="hidden" name="student_id" value="<?php echo e($student->id); ?>">
                  
                <?php if($lesson->attendances->contains('student_id', $student->id)): ?>
                  <?php
                    $attendance = $lesson->attendances->where('student_id', $student->id)->first();
                  ?>
                    <?php if($attendance->status == 1): ?> 
                      <input type="hidden" name="status" value="0">
                    <?php else: ?>
                      <input type="hidden" name="status" value="1">
                    <?php endif; ?>
                    <button type="submit" class="attendance-circle <?php echo e($attendance->status == 1 ? 'present':'absent'); ?>" ><?php echo e($attendance->status == 1 ? 'P':'A'); ?></button>
                <?php else: ?>
                  <input type="hidden" name="status" value="1">
                  <button type="submit"  class="attendance-circle"></button>
                <?php endif; ?>
              </form>
            <?php else: ?>
              <?php if($lesson->attendances->contains('student_id', $student->id)): ?>
                <?php
                  $attendance = $lesson->attendances->where('student_id', $student->id)->first();
                ?>
                  <button type="button" class="attendance-circle <?php echo e($attendance->status == 1 ? 'present':'absent'); ?>" ><?php echo e($attendance->status == 1 ? 'P':'A'); ?></button>
              <?php else: ?>
                <input type="hidden" name="status" value="1">
                <button type="button"  class="attendance-circle"></button>
              <?php endif; ?>
            <?php endif; ?>

          </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    </div>
  </div>
</div>

<br/>
<br/>
<?php $__env->stopSection(); ?>

<style>
  .avatar .rounded-circle {
    height: 40px;
    width: 40px;
    display: block;
    text-align: center;
    padding-top: 6px;
    font-size: 20px;
    font-weight: bold;
    color: #fff;
    background: #2992ee;
  }
  .attendance-circle {
    height: 30px;
    width: 30px !important;
    text-indent: 0;
    display: block;
    text-align: center;
    padding-top: 2px;
    font-size: 18px;
    font-weight: bold;
    color: #fff;
    background: #fff;
    border: 1px solid #000;
    border-radius: 20px;
  }
  .attendance-circle.present {
    background: darkgreen;
  }
  .attendance-circle.absent {
    background: darkred;
  }
</style>
<?php $__env->startSection('page-script'); ?>
<?php if(Session::has('alert-message')): ?>
<script>
    Toast.fire({
        type: "<?php echo e(Session::get('alert-class', 'info')); ?>",
        title: "<?php echo e(Session::get('alert-message')); ?>"
    });
</script>
<?php endif; ?>
<script type="text/javascript">
    var table;
    $(document).ready(function() {
      $('#chkHideCompletedLesson').change(function(){
        if($(this).is(":checked")) {
          $('.lesson.completed').hide();
        }
        else{
          $('.lesson').show();
        }
      });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/thereadernest/public_html/resources/views/lessons/report.blade.php ENDPATH**/ ?>