<?php if(isset($page_title) && $page_title != ''): ?>
    <?php $__env->startSection('title', $page_title . ' - ' . config('app.name')); ?>
<?php else: ?>
    <?php $__env->startSection('title', config('app.name')); ?>
<?php endif; ?>
<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    
  <div class="row">
    <div class="col-md-12 mb-4">
        <div class="card card-action mb-6">
            <div class="card-header align-items-center">
              <h5 class="card-action-title mb-0">
                <i class="ti ti-chart-bar ti-lg text-body me-4"></i>Activity Timeline
              </h5>
            </div>
            <div class="card-body pt-3">
              <ul class="timeline mb-0">
                <?php $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="timeline-item timeline-item-transparent">
                  <span class="timeline-point timeline-point-primary"></span>
                  <div class="timeline-event">
                    <?php 
                        $activity = get_activity_details($activity);
                    ?>
                    <div class="timeline-header mb-3">
                      <h6 class="mb-0"><?php echo e($activity['subject']); ?> is <?php echo e($activity['description']); ?></h6>
                      <small class="text-muted"><?php echo e(date(config('constant.date_format'), strtotime($activity['created_at']))); ?></small>
                    </div>
                    <p class="mb-2">
                        <a href="<?php echo e($activity['causer_url']); ?>"><?php echo e($activity['causer']); ?></a> <?php echo e($activity['description_lg']); ?> <a href="<?php echo e($activity['subject_url']); ?>"><?php echo e($activity['subject']); ?></a>
                    </p>
                  </div>
                </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
        </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('after-scripts'); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('page-script'); ?>
  <?php if(Session::has('alert-message')): ?>
      <script>
          Toast.fire({
              type: "<?php echo e(Session::get('alert-class', 'info')); ?>",
              title: "<?php echo e(Session::get('alert-message')); ?>"
          });
      </script>
  <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u384437918/domains/thereadernest.in/public_html/resources/views/activities/index.blade.php ENDPATH**/ ?>