<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(getSelectedLanguage()->direction); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title'); ?></title>

    <!-- Styles -->
    <style type="text/css">
        :root {
            --secondary-color: #536d79;
            --primary-color: <?php echo e(getSetting('PRIMARY_COLOR')); ?>;
        }

    </style>
    <link href="<?php echo e(asset('assets/meeting/css/app.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/meeting/css/fa.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/meeting/css/toastr.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/meeting/css/style.css')); ?>" rel="stylesheet">
    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/img/favicon/favicon.ico')); ?>">
    <?php echo $__env->yieldContent('style'); ?>

    <style>
        <?php echo getSetting('CUSTOM_CSS'); ?>

    </style>
    <?php echo getSetting('CUSTOM_JS'); ?>

</head>

<body>
    <div id="app">
        <nav class="navbar navbar-expand-md">
            <a class="navbar-brand" href="<?php echo e(url('/')); ?>" target="_blank">
                <img src="<?php echo e(asset('assets/img/logo-small.png')); ?>"
                    alt="<?php echo e(config('app.name')); ?>" class="logo-inner">
                <span class="app-name"><?php echo e(config('app.name')); ?></span>
            </a>
        </nav>

        <main class="pt-4 mb-5 mb-md-0">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>

    <script>
        const cookieConsent = "<?php echo e(getSetting('COOKIE_CONSENT')); ?>";
        const googleAnalyticsTrackingId = "<?php echo e(getSetting('GOOGLE_ANALYTICS_ID')); ?>";
        const socialInvitation = "<?php echo e(getSetting('SOCIAL_INVITATION')); ?>";

        const languages = {
            error_occurred: "<?php echo e(__('An error occurred, please try again')); ?>",
            data_updated: "<?php echo e(__('Data updated successfully')); ?>",
            no_meeting: "<?php echo e(__('The meeting does not exist')); ?>",
            meeting_created: "<?php echo e(__('The meeting has been created')); ?>",
            confirmation: "<?php echo e(__('Are you sure')); ?>",
            meeting_deleted: "<?php echo e(__('The meeting has been deleted')); ?>",
            link_copied: "<?php echo e(__('Meeting link has been copied to the clipboard')); ?>",
            meeting_updated: "<?php echo e(__('The meeting has been updated')); ?>",
            sending_invite: "<?php echo e(__('Sending the invitation')); ?>",
            invite_sent: "<?php echo e(__('Invitation has been sent')); ?>",
            inviteMessage: "<?php echo e(__('Hey there! Join me for a meeting at this link')); ?>",
            no_session: "<?php echo e(__('Could not get the session details')); ?>",
            kicked: "<?php echo e(__('You have been kicked out of the meeting')); ?>",
            uploading: "<?php echo e(__('Uploading the file')); ?>",
            meeting_ended_tutor: "<?php echo e(__('The meeting has been ended by the tutor')); ?>",
            meeting_ended_student: "<?php echo e(__('You have come out of the meeting')); ?>",
            cant_connect: "<?php echo e(__('Could not connect to the server, please try again later')); ?>",
            invalid_password: "<?php echo e(__('The password is invalid')); ?>",
            already_joined: "<?php echo e(__('You have already joined the meeting.')); ?>",
            meeting_join_issue: "<?php echo e(__('There was some issue while joining meeting.')); ?>",
            meeting_leave_issue: "<?php echo e(__('There was some issue while leaving meeting.')); ?>",
            no_device: "<?php echo e(__('Could not get the devices, please check the permissions and try again. Error')); ?>",
            approve: "<?php echo e(__('Approve')); ?>",
            decline: "<?php echo e(__('Decline')); ?>",
            request_join_meeting: "<?php echo e(__('Request to join the meeting ')); ?>",
            allow_at_lease_one_media_to_join: "<?php echo e(__('Please allow at leaset one media ( audio or video ) to join the meeting.')); ?>",
            request_declined: "<?php echo e(__('Your request has been declined by the tutor')); ?>",
            double_click: "<?php echo e(__('Double click on the video to make it fullscreen')); ?>",
            single_click: "<?php echo e(__('Single click on the video to turn picture-in-picture mode on')); ?>",
            error_message: "<?php echo e(__('An error occurred')); ?>",
            kick_user: "<?php echo e(__('Kick this user')); ?>",
            participant_joined: "<?php echo e(__('has joined the meeting')); ?>",
            confirmation_kick: "<?php echo e(__('Are you sure you want to kick this user')); ?>",
            participant_left: "<?php echo e(__('A participant has left the meeting')); ?>",
            camera_on: "<?php echo e(__('Camera has been turned on')); ?>",
            camera_off: "<?php echo e(__('Camera has been turned off')); ?>",
            mic_unmute: "<?php echo e(__('Mic has been unmute')); ?>",
            mic_mute: "<?php echo e(__('Mic has been muted')); ?>",
            no_video: "<?php echo e(__('The video is not playing or has no video track')); ?>",
            no_pip: "<?php echo e(__('Picture-in-picture mode is not supported in this browser')); ?>",
            link_copied: "<?php echo e(__('The meeting invitation link has been copied to the clipboard')); ?>",
            cant_share_screen: "<?php echo e(__('Could not share the screen, please check the permissions and try again')); ?>",
            max_file_size: "<?php echo e(__('Maximum file size allowed (MB)')); ?>",
            view_file: "<?php echo e(__('View File')); ?>",
            hand_raised: "<?php echo e(__('have raised hand')); ?>",
            hand_raised_self: "<?php echo e(__('you have raised hand')); ?>",
            your_screen: "<?php echo e(__('Your screen')); ?>",
            not_started: "<?php echo e(__('The meeting has not been started yet')); ?>",
            meeting_full: "<?php echo e(__('The meeting is full')); ?>",
            please_wait: "<?php echo e(__('Please wait while the tutor check your request')); ?>",
            request_record_meeting: "<?php echo e(__('Request to record the meeting')); ?>",
            record_request_declined: "<?php echo e(__('You recording request was not approved')); ?>",
            feature_not_supported: "<?php echo e(__('This feature is not yet supported in your browser')); ?>",
            feature_not_available: "<?php echo e(__('This feature is not available in the current meeting plan')); ?>",
            leave_meeting_confirmation: "<?php echo e(__('Are you sure wants to leave meeting ?')); ?>",
            reload_page: "<?php echo e(__('Are you sure wants to reload the page ?')); ?>",
            password: "<?php echo e(__('Password: ')); ?>",
            calendar_check: "<?php echo e(__('Please set a date and time')); ?>",
            recording_started: "<?php echo e(__('The recording has been started')); ?>",
            token_copied: "<?php echo e(__('API Token has been copied to the clipboard')); ?>",
            screen: "<?php echo e(__('Screen')); ?>",
            tutor: "<?php echo e(__('Tutor')); ?>",
            you_muted: "<?php echo e(__('You muted all the participants')); ?>",
            you_unmuted: "<?php echo e(__('You unmuted all the participants')); ?>",
            mic_muted_tutor: "<?php echo e(__('Mic has been muted by the tutor')); ?>",
            mic_unmuted_tutor: "<?php echo e(__('Mic has been unmuted by the tutor')); ?>",
        }
    </script>

    <!-- Scripts -->
    <script src="<?php echo e(asset('assets/meeting/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/meeting/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/meeting/js/app.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/meeting/js/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/meeting/js/main.js')); ?>"></script>
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH /home/thereadernest/public_html/resources/views/layouts/meeting/index.blade.php ENDPATH**/ ?>