<?php if(isset($page_title) && $page_title!=''): ?>
    <?php $__env->startSection('title', $page_title.' - '.config('app.name')); ?>
<?php else: ?>
    <?php $__env->startSection('title', config('app.name')); ?>
<?php endif; ?>
<?php $__env->startSection('page-style'); ?>
<style type="text/css">
	.th-width{
		width: 25% !important;
	}
	h4.text-custom{
        font-weight: 500;
        color: #2cabe3;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php
  $noRecordingExists = (count($files) == 0);
?>
<?php
  $status = get_lesson_status($lesson->status);
?>

<div class="row mb-10">
  <div class="col-md-4">
    <div class="card h-100">
      <div class="card-body">
        <h5 class="mb-2"><?php echo e($lesson->name); ?></h5>
        <p class="small">  <?php echo e($lesson->batch->name); ?> </p>
        <div id="lessonThumbnail" class="bg-label-primary rounded text-center mb-4 pt-4">
          <img class="img-fluid" src="<?php echo e(asset('assets/img/illustrations/girl-with-laptop.png')); ?>" alt="Card girl image" width="140">
        </div>
        <div class="mb-4 d-flex flex-column flex-md-row gap-4 text-nowrap flex-wrap flex-md-nowrap flex-lg-wrap flex-xxl-nowrap">
          <a class="w-100 btn btn-label-<?php echo e($status ['type']); ?> <?php echo e($status ['type']); ?>-effect" href="javascript:void(0)">
            <span><?php echo e($status['status']); ?></span>
          </a>
        </div>
        <div class="row mb-4 g-3">
          <div class="col-12">
            <div class="d-flex">
              <div class="avatar flex-shrink-0 me-3">
                <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-user ti-28px"></i></span>
              </div>
              <div>
                <h6 class="mb-0 text-nowrap"><?php echo e($lesson->batch->tutor->full_name); ?></h6>
                <small>Tutor</small>
              </div>
            </div>
          </div>
          <div class="col-12">
            <div class="d-flex">
              <div class="avatar flex-shrink-0 me-3">
                <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-calendar-event ti-28px"></i></span>
              </div>
              <div>
                <h6 class="mb-0 text-nowrap"><?php echo e(date(config('constant.date_format_new'), strtotime($lesson->start_date))); ?></h6>
                <small>Date</small>
              </div>
            </div>
          </div>
          <div class="col-6">
            <div class="d-flex">
              <div class="avatar flex-shrink-0 me-3">
                <span class="avatar-initial rounded bg-label-primary"><i class="ti ti-clock ti-28px"></i></span>
              </div>
              <div>
                <h6 class="mb-0 text-nowrap"><?php echo e(date_diff_in_min($lesson->start_date, $lesson->end_date)); ?></h6>
                <small>Duration</small>
              </div>
            </div>
          </div>
        </div>
        <?php if(Auth::user()->role_name == RoleTutor): ?>
        <div class="row mb-4 g-3">
          <div class="col-12">
            <form action="<?php echo e(route('lessons.status')); ?>"  class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST">
              <?php echo csrf_field(); ?>
              <input type="hidden" name="id" id="id" value="<?php echo e(isset($lesson->id) ? $lesson->id : ''); ?>">
              <div class="mt-6 col-md-12 form-password-toggle fv-plugins-icon-container  <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                <?php if($lesson->status == LessonStatusPlanned && $can_start_lesson): ?>
                  <select id="status" name="status" class="form-select">
                    <option disabled></option>
                    <option value="<?php echo e(LessonStatusInProgress); ?>">Start Lesson</option>
                    <option value="<?php echo e(LessonStatusCancelled); ?>">Cancel Lesson</option>
                  </select> 
                  <br>
                  <button type="submit" class="btn btn-primary w-100 waves-effect waves-light">Save</button>
                <?php elseif($lesson->status == LessonStatusInProgress): ?>
                  <select id="status" name="status" class="form-select">
                      <option disabled></option>
                      <option value="<?php echo e(LessonStatusCompleted); ?>">Complete Lesson</option>
                      <option value="<?php echo e(LessonStatusCancelled); ?>">Cancel Lesson</option>
                  </select> 
                  <br>
                  <button type="submit" class="btn btn-primary w-100 waves-effect waves-light">Save</button>
                <?php elseif($lesson->status == LessonStatusCompleted): ?>
                  <select id="status" name="status" class="form-select">
                    <option disabled></option>
                    <option value="<?php echo e(LessonStatusInProgress); ?>">Re-start Lesson</option>
                  </select> 
                  <br>
                  <button type="submit" class="btn btn-primary w-100 mb-5 waves-effect waves-light">Save</button>
                  <?php if($lesson->is_report_required): ?> 
                  <button type="button" id="btn-report-dialog" class="btn btn-primary w-100 waves-effect waves-light"  data-bs-toggle="modal" data-bs-target="#generateLessonReportModal">Generate Report</button>
                  <?php endif; ?>
                <?php endif; ?>
              </div>
            </form>
          </div>
        </div>
        <?php endif; ?>
        
        <?php if(Auth::user()->role_name == RoleStudent): ?>
        <div class="row mb-4 g-3">
          <div class="col-12">
          </div>
        </div>
        <?php endif; ?>
        
      </div>
    </div>
  </div>
  <div class="col-md-8">
    <div class="card h-100">
      <div class="card-header d-flex align-items-center justify-content-between">
        <div class="card-title mb-0">
          <h5 class="m-0 me-2">Students (<?php echo e($lesson->batch->students->count()); ?>)</h5>
        </div>
      </div>
      <div class="px-5 py-4 border border-start-0 border-end-0">
        <div class="d-flex justify-content-between align-items-center">
          <p class="mb-0 text-uppercase">Name</p>
          <p class="mb-0 text-uppercase">Attendence</p>
        </div>
      </div>
      <div class="card-body">
        <?php $__currentLoopData = $lesson->batch->students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php if(Auth::user()->role_name == RoleStudent): ?>
            <div class="d-flex justify-content-between align-items-center mb-6">
              <div class="d-flex align-items-center">
                <div class="avatar avatar me-4">
                  <span class="rounded-circle"><?php echo e($student->avatar_symbol); ?></span>
                </div>
                <div>
                  <div>
                    <h6 class="mb-0 text-truncate"><?php echo e($student->full_name); ?></h6>
                    <small class="text-truncate text-body"><?php echo e(strtoupper($student->gender)); ?></small>
                  </div>
                </div>
              </div>
              <div class="text-end">
                <?php if($lesson->attendances->contains('student_id', $student->id)): ?>
                  <?php
                    $attendance = $lesson->attendances->where('student_id', $student->id)->first();
                  ?>
                    <button type="button" class="attendance-circle <?php echo e($attendance->status == 1 ? 'present':'absent'); ?>" ><?php echo e($attendance->status == 1 ? 'P':'A'); ?></button>
                <?php else: ?>
                  <input type="hidden" name="status" value="1">
                  <button type="button"  class="attendance-circle"></button>
                <?php endif; ?>
              </div>
            </div>
          <?php endif; ?>

          <?php if(Auth::user()->role_name == RoleTutor): ?>
          <div class="d-flex justify-content-between align-items-center mb-6">
            <div class="d-flex align-items-center">
              <div class="avatar avatar me-4">
                <span class="rounded-circle"><?php echo e($student->avatar_symbol); ?></span>
              </div>
              <div>
                <div>
                  <h6 class="mb-0 text-truncate"><?php echo e($student->full_name); ?></h6>
                  <small class="text-truncate text-body"><?php echo e(strtoupper($student->gender)); ?></small>
                </div>
              </div>
            </div>
            <div class="text-end">
            <form action="<?php echo e(route('lessons.attendance')); ?>"  class="row g-6 fv-plugins-bootstrap5 fv-plugins-framework" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="lesson_id" value="<?php echo e($lesson->id); ?>">
                <input type="hidden" name="student_id" value="<?php echo e($student->id); ?>">
                  
                <?php if($lesson->attendances->contains('student_id', $student->id)): ?>
                  <?php
                    $attendance = $lesson->attendances->where('student_id', $student->id)->first();
                  ?>
                    <?php if($attendance->status == 1): ?> 
                      <input type="hidden" name="status" value="0">
                    <?php else: ?>
                      <input type="hidden" name="status" value="1">
                    <?php endif; ?>
                    <button type="submit" class="attendance-circle <?php echo e($attendance->status == 1 ? 'present':'absent'); ?>" ><?php echo e($attendance->status == 1 ? 'P':'A'); ?></button>
                <?php else: ?>
                  <input type="hidden" name="status" value="1">
                  <button type="submit"  class="attendance-circle"></button>
                <?php endif; ?>
              </form>
            </div>
          </div>
          <?php endif; ?>

          <?php if(Auth::user()->role_name == RoleAdmin || Auth::user()->role_name == RoleSuperAdmin): ?>
          <div class="d-flex justify-content-between align-items-center mb-6">
            <div class="d-flex align-items-center">
              <div class="avatar avatar me-4">
                <span class="rounded-circle"><?php echo e($student->avatar_symbol); ?></span>
              </div>
              <div>
                <div>
                  <h6 class="mb-0 text-truncate"><?php echo e($student->full_name); ?></h6>
                  <small class="text-truncate text-body"><?php echo e(strtoupper($student->gender)); ?></small>
                </div>
              </div>
            </div>
            <div class="text-end">
              <?php if($lesson->attendances->contains('student_id', $student->id)): ?>
                <?php
                  $attendance = $lesson->attendances->where('student_id', $student->id)->first();
                ?>
                  <button type="button" class="attendance-circle <?php echo e($attendance->status == 1 ? 'present':'absent'); ?>" ><?php echo e($attendance->status == 1 ? 'P':'A'); ?></button>
              <?php else: ?>
                <input type="hidden" name="status" value="1">
                <button type="button"  class="attendance-circle"></button>
              <?php endif; ?>
            </div>
          </div>
          <?php endif; ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    </div>
  </div>
</div>
<!-- Lesson Report Modal -->
<div class="modal fade" id="generateLessonReportModal" tabindex="-1" >
  <div class="modal-dialog modal-lg modal-simple modal-edit-user">
    <div class="modal-content">
      <div class="modal-body">
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        <div class="text-center mb-6">
          <h4 class="mb-2">Generate Lesson Report</h4>
          <p>Enter your valuable comments to generate Lesson Report.</p>
        </div>
        <form class="row g-6" method="POST" action="<?php echo e(route('lessons.generateReport' )); ?>">
          <?php echo csrf_field(); ?>
          <input type="hidden" name="lesson_id" value="<?php echo e($lesson->id); ?>">
          <div class="col-12">
            <label class="form-label" for="comments">Comments</label>
            <textarea
              type="text"
              id="comments"
              name="comments"
              class="form-control"
              placeholder="Enter Comments" ></textarea>
          </div>
          <div class="col-12 text-center">
            <button type="submit" class="btn btn-primary me-3">Submit</button>
            <button
              type="reset"
              class="btn btn-label-secondary"
              data-bs-dismiss="modal"
              aria-label="Close">
              Cancel
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<!--/ Edit User Modal -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
  <?php if(Session::has('alert-message')): ?>
  <script>
    Toast.fire({
        type: "<?php echo e(Session::get('alert-class', 'info')); ?>",
        title: "<?php echo e(Session::get('alert-message')); ?>"
    });
  </script>
  <?php endif; ?>

<script type='text/javascript'>
  $(document).ready(function(){
    
    var video = document.getElementById('recordingVideo');
    var source = document.getElementById('recordingVideoSource');

    $(document).on('click', '.recording-file', function () {
      let url = $(this).data('url');
      let file = $(this).data('file');
      $("#recording-title").text(file);

      video.pause();
      source.setAttribute('src', url);
      video.load();
      //video.play();
    });
  });

</script>
<?php $__env->stopSection(); ?>
<style>
  .avatar .rounded-circle {
    height: 40px;
    width: 40px;
    display: block;
    text-align: center;
    padding-top: 6px;
    font-size: 20px;
    font-weight: bold;
    color: #fff;
    background: #2992ee;
  }
  .attendance-circle {
    height: 30px;
    width: 30px !important;
    text-indent: 0;
    display: block;
    text-align: center;
    padding-top: 2px;
    font-size: 18px;
    font-weight: bold;
    color: #fff;
    background: #fff;
    border: 1px solid #000;
    border-radius: 20px;
    text-indent: -3px;
  }
  .attendance-circle.present {
    background: darkgreen;
  }
  .attendance-circle.absent {
    background: darkred;
  }
  .app-chat, .app-chat .app-chat-contacts, .app-chat .app-chat-history,
  .app-chat .app-chat-history .chat-history-body {
    min-height: 600px;
  }
  video {
    background: #000;
    margin: 0 auto;
  }
  .app-chat .app-chat-contacts .sidebar-body {
    height: 465px !important;
    overflow-y: scroll !important;
  }
</style>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/thereadernest/public_html/resources/views/lessons/view.blade.php ENDPATH**/ ?>