<?php if(isset($page_title) && $page_title!=''): ?>
    <?php $__env->startSection('title', $page_title.' - '.config('app.name')); ?>
<?php else: ?>
    <?php $__env->startSection('title', config('app.name')); ?>
<?php endif; ?>
<?php $__env->startSection('content'); ?>
<div class="card">
  <div class="card-header border-bottom">
    <div class="row">
      <div class="col-md-6">
        <h5 class="card-title mb-0">Tickets</h5>
      </div>
      <div class="col-md-6">
          <div class="dt-action-buttons text-xl-end text-lg-start text-md-end text-start d-flex align-items-center justify-content-end flex-md-row flex-column mb-6 mb-md-0 mt-n6 mt-md-0">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['create-ticket'])): ?>
            <div class="dt-buttons btn-group flex-wrap">
                  <a href="<?php echo e(route('tickets.add')); ?>" class="btn btn-secondary add-new btn-primary waves-effect waves-light" 
                  tabindex="0" type="button" ><span><i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block">Add Ticket</span></span></a> 
            </div>
            <?php endif; ?>
          </div>
      </div>
    </div>
  </div>
  <div class="card-body table-responsive pt-4">
    <table id="DataTable1" class="datatables-roles table">
      <thead class="border-top">
        <tr>
            <th>#</th>
            <th>Number</th>
            <th>Title</th>
            <th>Priority</th>
            <th>Status</th>
            <th>Created At</th>
            <th>Created By</th>
            <th>Action</th>
        </tr>
      </thead>
      <tbody>
      </tbody>
    </table>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
    <?php if(Session::has('alert-message')): ?>
    <script>
        Toast.fire({
            type: "<?php echo e(Session::get('alert-class', 'info')); ?>",
            title: "<?php echo e(Session::get('alert-message')); ?>"
        });
    </script>
    <?php endif; ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/libs/datatables/jquery.dataTables.min.css')); ?>"></script>
<link rel="stylesheet" href="<?php echo e(asset('assets/libs/datatables/responsive.dataTables.min.css')); ?>"></script>
<link rel="stylesheet" href="<?php echo e(asset('assets/libs/datatables/jquery.dataTable.orderride.css')); ?>"></script>
<script src="<?php echo e(asset('assets/libs/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/libs/datatables/dataTables.bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/libs/datatables/dataTables.responsive.min.js')); ?>"></script>
<script type="text/javascript">
    var table;
    $(document).ready(function() {
	    table=$('#DataTable1').DataTable({
	    	responsive: true,
	        processing: true,
	        serverSide: true,
	        searching: true,
	        ajax:{
	            headers: {'X-CSRF-Token': Laravel.csrfToken},
	            url:'<?php echo route("tickets"); ?>',
	            type:'GET',
	        },
	        columns: [
	            {data: 'id', name: 'id'},
	            {data: 'number', name: 'number'},
	            {data: 'title', name: 'title'},
	            {data: 'priority', name: 'priority'},
	            {data: 'status', name: 'status'},
	            {data: 'created_at', name: 'created_at'},
	            {data: 'created_by', name: 'created_by'},
	            {data: 'action', name: 'action', sortable:false}
	        ],
	        order: [[0, 'desc']]
	    });
    });
    function redrawDatatable(){
        $('#DataTable1').DataTable().ajax.reload();
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u384437918/domains/dev.thereadernest.in/public_html/resources/views/tickets/index.blade.php ENDPATH**/ ?>