
<?php if(isset($page_title) && $page_title!=''): ?>
    <?php $__env->startSection('title', $page_title.' - '.config('app.name')); ?>
<?php else: ?>
    <?php $__env->startSection('title', config('app.name')); ?>
<?php endif; ?>
<?php $__env->startSection('page-style'); ?>
<style type="text/css">
	.th-width{
		width: 25% !important;
	}
	h4.text-custom{
        font-weight: 500;
        color: #2cabe3;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-header border-bottom">
      <h5 class="card-title mb-0">View Role</h5>
    </div>
    <div class="card-body pt-4">
        <?php if($role->name=='admin' || $role->name=='super-admin'): ?>
            <?php
                $checkbox = '';
            ?>
        <?php else: ?>
            <?php
                $checkbox = '';
            ?>    
        <?php endif; ?>
        <ul class="list-unstyled my-3 py-1">
            <li class="d-flex align-items-center mb-4">
              <i class="ti ti-user ti-lg"></i><span class="fw-medium mx-2">Name:</span>
              <span><?php echo e(old( 'name', isset($role->name) ? $role->name : '')); ?></span>
            </li>
            <li class="d-flex align-items-center mb-4">
              <i class="ti ti-check ti-lg"></i><span class="fw-medium mx-2">Description:</span>
              <span><?php echo e(old( 'description', isset($role->description) ? $role->description : '')); ?></span>
            </li>
            <li class="d-flex align-items-center mb-4">
              <i class="ti ti-crown ti-lg"></i><span class="fw-medium mx-2">Permissions:</span>
            </li>
        </ul>
        
        <?php if(isset($permissions) && $permissions->count()>0): ?>
        <div class="col-12 fv-plugins-icon-container">
            <p class="mb-1">
                <div class="table-responsive mt-4">
                    <table class="table">
                    <thead>
                        <tr>
                        <th class="text-nowrap">Name</th>
                        <th class="text-nowrap">Permission</th>
                        <th class="text-nowrap text-center"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                        <td class="text-nowrap text-heading"><?php echo e($permission->display_name); ?></td>
                        <td class="text-nowrap text-heading"><?php echo e($permission->name); ?></td>
                        <td>
                            <div class="form-check d-flex justify-content-center">
                                <?php if($checkbox!=''): ?>
                                    <input type="checkbox" name="permissions[]" id="<?php echo e($permission->name); ?>" value="<?php echo e($permission->name); ?>" <?php echo $checkbox; ?>  checked>
                                <?php else: ?>
                                    <input type="checkbox" name="permissions[]" id="<?php echo e($permission->name); ?>" value="<?php echo e($permission->name); ?>" <?php echo $checkbox; ?>  <?php echo e(($role->hasPermissionTo($permission->name))?'checked':''); ?>>
                                <?php endif; ?>
                            </div>
                        </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    </table>
                </div>        
            </p>
        </div>
    <?php endif; ?>
        
    </div>
</div>
<br/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
<?php if(Session::has('alert-message')): ?>
<script>
    Toast.fire({
        type: "<?php echo e(Session::get('alert-class', 'info')); ?>",
        title: "<?php echo e(Session::get('alert-message')); ?>"
    });
</script>
<?php endif; ?>
<script type="text/javascript">
    var table;
    $(document).ready(function() {
      $('#chkHideCompletedLesson').change(function(){
        if($(this).is(":checked")) {
          $('.lesson.completed').hide();
        }
        else{
          $('.lesson').show();
        }
      });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/thereadernest/public_html/resources/views/roles/view.blade.php ENDPATH**/ ?>