
(function(){
  function initNoticeMarquee(){
    document.querySelectorAll('.notice-viewport').forEach(function(view){
      var list = view.querySelector('.notice-list');
      if(!list) return;
      // duplicate once for continuous scroll
      if(!list.dataset.cloned){
        var clone = list.cloneNode(true);
        clone.dataset.cloned = '1';
        list.parentNode.appendChild(clone);
        list.dataset.cloned = '1';
      }
      // compute heights
      var first = view.querySelector('.notice-list');
      var totalHeight = first.scrollHeight;
      var parent = view.closest('.notice-box-content');
      // speed heuristic: use CSS var --marquee-speed as ms per block
      var speed = parseInt(getComputedStyle(parent).getPropertyValue('--marquee-speed')) || 3000;
      var seconds = Math.max(6, Math.round((totalHeight / 50) * (speed/1000))); // seconds
      // apply animation to both lists
      view.querySelectorAll('.notice-list').forEach(function(n){ n.classList.add('animated'); n.style.animationDuration = (seconds*2) + 's'; n.style.animationPlayState = 'running'; });
      // pause on hover/focus handled by CSS
    });
  }
  if(document.readyState==='loading') document.addEventListener('DOMContentLoaded', initNoticeMarquee); else initNoticeMarquee();
})();
