<?php
/**
 * Plugin Name: Latest CBSE Notice Marquee - v6 (Fixed)
 * Description: Notice box with header and contained vertical marquee (bottom-to-top). Shortcode: [latest_cbse_notice_v6 count="12" speed="3000" height="260"]
 * Version: 1.0.1
 * Author: ChatGPT
 * License: GPLv2+
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/* Register CPT and taxonomy (if not exists) */
add_action( 'init', function() {
    if ( ! post_type_exists( 'news_item' ) ) {
        register_post_type( 'news_item', array(
            'labels' => array(
                'name' => 'News Items',
                'singular_name' => 'News Item',
            ),
            'public'    => false,
            'show_ui'   => true,
            'supports'  => array( 'title', 'editor', 'page-attributes' ),
            'menu_icon' => 'dashicons-megaphone',
        ) );
    }

    if ( ! taxonomy_exists( 'news_category' ) ) {
        register_taxonomy( 'news_category', 'news_item', array(
            'hierarchical' => true,
            'show_ui'      => true,
            'public'       => false,
        ) );
    }
}, 1 );

/* Settings page for View All URL */
add_action( 'admin_menu', function() {
    add_options_page( 'Notice Marquee Settings', 'Notice Marquee', 'manage_options', 'notice-marquee', 'notice_marquee_settings_page' );
} );

function notice_marquee_settings_page() {
    if ( ! current_user_can( 'manage_options' ) ) {
        return;
    }

    if ( $_POST && check_admin_referer( 'notice_marquee_save', 'notice_marquee_nonce' ) ) {
        update_option( 'notice_marquee_view_all', esc_url_raw( $_POST['notice_marquee_view_all'] ) );
        echo '<div class="updated"><p>Saved.</p></div>';
    }

    $v = esc_url( get_option( 'notice_marquee_view_all', '/notices/' ) );
    ?>
    <div class="wrap"><h1>Notice Marquee Settings</h1>
    <form method="post"><?php wp_nonce_field( 'notice_marquee_save', 'notice_marquee_nonce' ); ?>
    <table class="form-table"><tr><th>View All URL</th><td><input type="url" name="notice_marquee_view_all" value="<?php echo esc_attr( $v ); ?>" style="width:420px;" /></td></tr></table>
    <?php submit_button( 'Save Settings' ); ?></form></div>
    <?php
}

/* Enqueue assets */
add_action( 'wp_enqueue_scripts', function() {
    wp_register_style( 'notice-v6-style', false );
    $css = @file_get_contents( plugin_dir_path( __FILE__ ) . 'assets/style.css' );
    if ( $css ) {
        wp_add_inline_style( 'notice-v6-style', $css );
        wp_enqueue_style( 'notice-v6-style' );
    }

    wp_register_script( 'notice-v6-js', false );
    $js = @file_get_contents( plugin_dir_path( __FILE__ ) . 'assets/script.js' );
    if ( $js ) {
        wp_add_inline_script( 'notice-v6-js', $js );
        wp_enqueue_script( 'notice-v6-js' );
    }
} );

/* Helper: fetch latest items */
function notice_v6_get_items( $count = 12 ) {
    $q = new WP_Query( array(
        'post_type'      => 'news_item',
        'posts_per_page' => intval( $count ),
        'post_status'    => 'publish',
        'orderby'        => 'date',
        'order'          => 'DESC',
    ) );

    $items = array();

    if ( $q->have_posts() ) {
        while ( $q->have_posts() ) {
            $q->the_post();
            $id   = get_the_ID();
            $link = get_post_meta( $id, '_lcv4_link', true );
            $items[] = array(
                'id'    => $id,
                'title' => get_the_title(),
                'link'  => $link ? $link : get_permalink( $id ),
                'date'  => get_the_date( 'd/m/Y' ),
            );
        }
        wp_reset_postdata();
    }

    return $items;
}

/* Shortcode */
add_shortcode( 'latest_cbse_notice_v6', function( $atts ) {
    $atts = shortcode_atts( array(
        'count'  => 12,
        'speed'  => 3000,
        'height' => 260,
    ), $atts, 'latest_cbse_notice_v6' );

    $items    = notice_v6_get_items( intval( $atts['count'] ) );
    $view_all = esc_url( get_option( 'notice_marquee_view_all', '/notices/' ) );

    ob_start();
    ?>
    <div class="notice-box-wrap">
      <div class="notice-box-header">
        <div class="notice-box-title">Notice</div>
      </div>

      <div class="notice-box-content" style="--marquee-height:<?php echo intval( $atts['height'] ); ?>px; --marquee-speed:<?php echo intval( $atts['speed'] ); ?>ms;">
        <div class="notice-viewport" tabindex="0" aria-live="polite" aria-label="Notices list">
          <ul class="notice-list">
            <?php foreach ( $items as $it ) : ?>
              <li class="notice-item">
                <a href="<?php echo esc_url( $it['link'] ); ?>" target="_blank" rel="noopener noreferrer">
                  <span class="dot">›</span>
                  <span class="notice-text"><?php echo esc_html( $it['title'] ); ?></span>
                </a>
                <span class="notice-date"><?php echo esc_html( $it['date'] ); ?></span>
              </li>
            <?php endforeach; ?>
          </ul>
        </div>
        <div class="notice-footer"><a class="notice-viewall" href="<?php echo esc_url( $view_all ); ?>">View All ›</a></div>
      </div>
    </div>
    <?php
    return ob_get_clean();
} );
