<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAttendancesTable extends Migration
{
    public function up()
    {
        Schema::create('attendances', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->date('date');
            $table->timestamp('check_in')->nullable();
            $table->timestamp('check_out')->nullable();
            $table->integer('worked_minutes')->nullable();
            $table->enum('status', ['Present','Absent','Half Day','Leave','WFH','Late'])->default('Present');
            $table->text('notes')->nullable();
            $table->timestamps();
            $table->unique(['user_id','date']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('attendances');
    }
}
