# Attendance + Daily Task Report — Laravel Skeleton

This ZIP contains a skeleton Laravel project (PHP files, migrations, controllers, Blade views) intended to be extended into a full Laravel app.
It is **not** a full composer-installed Laravel vendor directory. Complete the steps below to deploy on GoDaddy cPanel.

## What's included
- composer.json
- .env.example
- app/Models/*.php
- app/Http/Controllers/*.php
- database/migrations/*.php
- routes/web.php, routes/api.php
- resources/views/* (Blade templates)
- README and deployment notes

## Deployment (recommended)
1. Extract ZIP on your local machine.
2. Run `composer install` (requires Composer & PHP 8+ locally or on server).
3. Copy `.env.example` to `.env` and set DB credentials and APP_KEY (run `php artisan key:generate`).
4. Upload project to GoDaddy (public folder -> `public_html/<your-folder>`). Alternatively set up as subdomain.
5. Create MySQL database via cPanel and update `.env`.
6. Run `php artisan migrate --force`.
7. Set folder permissions:
   `chmod -R 775 storage bootstrap/cache`
8. (If no SSH on cPanel) you can upload vendor directory from your local machine after running `composer install`.
9. Set APP_TIMEZONE=Asia/Kolkata in `.env`.

## Notes
- This skeleton focuses on Attendance + Task time entries and reporting.
- You will need to run `composer install`, set up a webserver document root to the `public` directory, and configure scheduler/cron if you want auto-checkout cron tasks.

If you want, I can now:
- Generate a complete ZIP that includes `vendor/` (larger) — but this requires running Composer here (not available).
- Convert UI to Bootstrap instead of Tailwind (currently Blade uses Tailwind classes).
