<?php
namespace App\Http\Controllers;
use App\Models\Attendance;
use App\Models\AttendanceLog;
use App\Models\User;
use Illuminate\Http\Request;
use Carbon\Carbon;

class AttendanceController extends Controller
{
    public function today(Request $request)
    {
        $user = $request->user();
        $date = Carbon::now()->toDateString();
        $attendance = Attendance::firstOrCreate(
            ['user_id'=>$user->id,'date'=>$date],
            ['status'=>'Present']
        );
        return view('attendance', compact('attendance'));
    }

    public function checkIn(Request $request)
    {
        $user = $request->user();
        $date = Carbon::now()->toDateString();
        $attendance = Attendance::firstOrCreate(['user_id'=>$user->id,'date'=>$date]);
        $attendance->check_in = Carbon::now();
        $attendance->status = 'Present';
        $attendance->save();

        AttendanceLog::create([
            'attendance_id'=>$attendance->id,
            'action'=>'checkin',
            'actor_id'=>$user->id,
            'meta'=>json_encode(['ip'=>$request->ip()])
        ]);

        return redirect()->back()->with('success','Checked in at '.now());
    }

    public function checkOut(Request $request)
    {
        $user = $request->user();
        $date = Carbon::now()->toDateString();
        $attendance = Attendance::where('user_id',$user->id)->where('date',$date)->first();
        if(!$attendance) {
            return redirect()->back()->with('error','No check-in found');
        }
        $attendance->check_out = Carbon::now();
        // compute minutes
        if($attendance->check_in) {
            $minutes = Carbon::parse($attendance->check_in)->diffInMinutes($attendance->check_out);
            $attendance->worked_minutes = $minutes;
        }
        $attendance->save();

        AttendanceLog::create([
            'attendance_id'=>$attendance->id,
            'action'=>'checkout',
            'actor_id'=>$user->id,
            'meta'=>json_encode(['ip'=>$request->ip()])
        ]);

        return redirect()->back()->with('success','Checked out at '.now());
    }

    public function manualEdit(Request $request, $id)
    {
        // admin only - basic implementation
        $this->authorize('admin-only');
        $attendance = Attendance::findOrFail($id);
        $attendance->fill($request->only(['check_in','check_out','status','notes']));
        // recalc worked minutes
        if($attendance->check_in && $attendance->check_out) {
            $attendance->worked_minutes = \Carbon\Carbon::parse($attendance->check_in)->diffInMinutes($attendance->check_out);
        }
        $attendance->save();

        AttendanceLog::create([
            'attendance_id'=>$attendance->id,
            'action'=>'manual_edit',
            'actor_id'=>$request->user()->id,
            'meta'=>json_encode($request->all())
        ]);

        return redirect()->back()->with('success','Attendance updated');
    }
}
