<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class AttendanceLog extends Model
{
    protected $fillable = ['attendance_id','action','actor_id','meta'];

    protected $casts = [
        'meta' => 'array'
    ];

    public function attendance() {
        return $this->belongsTo(Attendance::class);
    }
    public function actor() {
        return $this->belongsTo(User::class, 'actor_id');
    }
}
