<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AttendanceController;
use App\Http\Controllers\TaskController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\AuthController;

Route::get('/', function(){ return redirect('/dashboard'); });

// Auth
Route::get('/login', [AuthController::class,'showLogin'])->name('login')->middleware('guest');
Route::post('/login', [AuthController::class,'login'])->middleware('guest');
Route::get('/register', [AuthController::class,'showRegister'])->middleware('guest');
Route::post('/register', [AuthController::class,'register'])->middleware('guest');
Route::post('/logout', [AuthController::class,'logout'])->middleware('auth');

// Protected routes
Route::middleware(['auth'])->group(function(){
    Route::get('/dashboard', function(){ return view('dashboard'); })->name('dashboard');

    // Attendance
    Route::get('/attendance', [AttendanceController::class,'today'])->name('attendance.today');
    Route::post('/attendance/checkin', [AttendanceController::class,'checkIn'])->name('attendance.checkin');
    Route::post('/attendance/checkout', [AttendanceController::class,'checkOut'])->name('attendance.checkout');
    Route::post('/attendance/{id}/edit', [AttendanceController::class,'manualEdit'])->name('attendance.manualEdit');

    // Tasks
    Route::get('/tasks', [TaskController::class,'index'])->name('tasks.index');
    Route::post('/tasks', [TaskController::class,'store'])->name('tasks.store');
    Route::post('/tasks/{id}/start', [TaskController::class,'start'])->name('tasks.start');
    Route::post('/tasks/{id}/stop', [TaskController::class,'stop'])->name('tasks.stop');
    Route::post('/tasks/manual-entry', [TaskController::class,'manualEntry'])->name('tasks.manualEntry');

    // Reports
    Route::get('/reports/daily-tasks', [ReportController::class,'dailyTasks'])->name('reports.dailyTasks');
    Route::get('/reports/daily-tasks/export', [ReportController::class,'exportCsv'])->name('reports.dailyTasks.export');
});
